/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.command.Command;
import dev.triumphteam.cmd.core.command.ParentCommand;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.processor.RootCommandProcessor;
import dev.triumphteam.cmd.core.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootCommand<D, S>
extends ParentCommand<D, S> {
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;

    public RootCommand(@NotNull RootCommandProcessor<D, S> processor) {
        super(processor);
        this.name = processor.getName();
        this.description = processor.getDescription();
        this.aliases = processor.getAliases();
        this.syntax = "/" + this.name;
    }

    @Override
    public void execute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> arguments) {
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        Command command = this.findCommand(sender, arguments, true);
        if (command == null) {
            return;
        }
        try {
            command.execute(sender, null, arguments);
        }
        catch (Throwable exception) {
            throw new CommandExecutionException("An error occurred while executing the command").initCause(exception instanceof InvocationTargetException ? exception.getCause() : exception);
        }
    }

    @Override
    public void executeNonLinear(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> commands, @NotNull Map<String, Pair<String, Object>> arguments) {
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        Command command = this.findCommand(sender, commands, true);
        if (command == null) {
            return;
        }
        try {
            command.executeNonLinear(sender, null, commands, arguments);
        }
        catch (Throwable exception) {
            throw new CommandExecutionException("An error occurred while executing the command").initCause(exception instanceof InvocationTargetException ? exception.getCause() : exception);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean hasArguments() {
        return false;
    }
}

