/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.Command;
import dev.triumphteam.cmd.core.command.ParentCommand;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.extention.Result;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import dev.triumphteam.cmd.core.processor.ParentCommandProcessor;
import dev.triumphteam.cmd.core.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentSubCommand<D, S>
extends ParentCommand<D, S> {
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;
    private final Object invocationInstance;
    private final Constructor<?> constructor;
    private final boolean isStatic;
    private final StringInternalArgument<S> argument;
    private final boolean hasArgument;

    public ParentSubCommand(@NotNull Object invocationInstance, @NotNull Constructor<?> constructor, boolean isStatic, @Nullable StringInternalArgument<S> argument, @NotNull ParentCommandProcessor<D, S> processor, @NotNull Command<D, S> parentCommand) {
        super(processor);
        this.invocationInstance = invocationInstance;
        this.constructor = constructor;
        this.isStatic = isStatic;
        this.argument = argument;
        this.hasArgument = argument != null;
        this.name = processor.getName();
        this.description = processor.getDescription();
        this.aliases = processor.getAliases();
        this.syntax = this.createSyntax(parentCommand, processor);
    }

    @Override
    public void execute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> arguments) throws Throwable {
        Object instance;
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        if (this.hasArgument) {
            String argumentName = arguments.peek() == null ? "" : arguments.pop();
            @NotNull Result<Object, BiFunction<CommandMeta, String, InvalidArgumentContext>> result = this.argument.resolve(sender, argumentName);
            if (result instanceof Result.Failure) {
                this.getMessageRegistry().sendMessage(MessageKey.INVALID_ARGUMENT, sender, (InvalidArgumentContext)((BiFunction)((Result.Failure)result).getFail()).apply(this.getMeta(), this.syntax));
                return;
            }
            if (!(result instanceof Result.Success)) {
                throw new CommandExecutionException("An error occurred resolving arguments", "", this.name);
            }
            instance = this.createInstanceWithArgument(instanceSupplier, ((Result.Success)result).getValue());
        } else {
            instance = this.createInstance(instanceSupplier);
        }
        Command command = this.findCommand(sender, arguments, true);
        if (command == null) {
            return;
        }
        command.execute(sender, () -> instance, arguments);
    }

    @Override
    public void executeNonLinear(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> commands, @NotNull Map<String, Pair<String, Object>> arguments) throws Throwable {
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        Command command = this.findCommand(sender, commands, true);
        if (command == null) {
            return;
        }
        Object instance = this.createInstance(instanceSupplier);
        command.executeNonLinear(sender, () -> instance, commands, arguments);
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        if (arguments.size() == 1 && this.hasArgument) {
            return this.argument.suggestions(sender, arguments);
        }
        if (this.hasArgument) {
            arguments.pop();
        }
        return super.suggestions(sender, arguments);
    }

    @NotNull
    private Object createInstance(@Nullable Supplier<Object> instanceSupplier) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (!this.isStatic) {
            return this.constructor.newInstance(instanceSupplier == null ? this.invocationInstance : instanceSupplier.get());
        }
        return this.constructor.newInstance(new Object[0]);
    }

    @NotNull
    private Object createInstanceWithArgument(@Nullable Supplier<Object> instanceSupplier, @Nullable Object argumentValue) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (!this.isStatic) {
            return this.constructor.newInstance(instanceSupplier == null ? this.invocationInstance : instanceSupplier.get(), argumentValue);
        }
        return this.constructor.newInstance(argumentValue);
    }

    @NotNull
    private String createSyntax(@NotNull Command parentCommand, @NotNull CommandProcessor<D, S> processor) {
        Syntax syntaxAnnotation = processor.getSyntaxAnnotation();
        if (syntaxAnnotation != null) {
            return syntaxAnnotation.value();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(parentCommand.getSyntax()).append(" ");
        if (this.hasArgument) {
            builder.append("<").append(this.argument.getName()).append(">");
        } else {
            builder.append(this.name);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean hasArguments() {
        return this.argument != null;
    }
}

