/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.command.Command;
import dev.triumphteam.cmd.core.command.ParentSubCommand;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extention.command.Settings;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.InvalidCommandContext;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParentCommand<D, S>
implements Command<D, S> {
    private Command<D, S> defaultCommand = null;
    private final Map<String, Command<D, S>> commands = new HashMap<String, Command<D, S>>();
    private final Map<String, Command<D, S>> commandAliases = new HashMap<String, Command<D, S>>();
    private final CommandMeta meta;
    private final Settings<D, S> settings;
    private Command<D, S> parentCommandWithArgument;
    private final MessageRegistry<S> messageRegistry;
    private final SenderExtension<D, S> senderExtension;

    public ParentCommand(@NotNull CommandProcessor<D, S> processor) {
        Settings.Builder settingsBuilder = new Settings.Builder();
        processor.captureRequirements(settingsBuilder);
        this.meta = processor.createMeta(settingsBuilder);
        this.messageRegistry = processor.getRegistryContainer().getMessageRegistry();
        this.senderExtension = processor.getCommandOptions().getCommandExtensions().getSenderExtension();
        this.settings = settingsBuilder.build();
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String argument = arguments.peek();
        if (argument == null) {
            return Collections.emptyList();
        }
        Command<D, S> command = this.findCommand(sender, arguments, false);
        if (command == null) {
            return this.commands.entrySet().stream().filter(it -> ((Command)it.getValue()).getCommandSettings().testRequirements(sender, this.meta, this.senderExtension)).filter(it -> ((String)it.getKey()).startsWith(argument)).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return command.suggestions(sender, arguments);
    }

    public void addCommands(@NotNull Object instance, @NotNull List<Command<D, S>> commands) {
        for (Command<D, S> command : commands) {
            if (command instanceof ParentSubCommand && command.hasArguments()) {
                if (this.parentCommandWithArgument != null) {
                    throw new CommandRegistrationException("Only one inner command with argument is allowed per command", instance.getClass());
                }
                this.parentCommandWithArgument = command;
                return;
            }
            if (command.isDefault()) {
                this.defaultCommand = command;
            } else {
                this.commands.put(command.getName(), command);
            }
            for (String alias : command.getAliases()) {
                this.commandAliases.put(alias, command);
            }
        }
    }

    @Nullable
    protected Command<D, S> findCommand(@NotNull S sender, @NotNull Deque<String> arguments, boolean message) {
        String name = arguments.peek();
        Command<D, S> defaultCommand = this.defaultCommand;
        if (name == null) {
            if (defaultCommand == null && message) {
                this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, sender, new InvalidCommandContext(this.meta, ""));
            }
            return defaultCommand;
        }
        Command<D, S> command = this.getCommandByName(name);
        if (command != null) {
            arguments.pop();
            return command;
        }
        if (defaultCommand == null || !defaultCommand.hasArguments()) {
            if (this.parentCommandWithArgument == null && message) {
                this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, sender, new InvalidCommandContext(this.meta, name));
            }
            return this.parentCommandWithArgument;
        }
        return defaultCommand;
    }

    @Nullable
    public Command<D, S> getCommand(@NotNull String name) {
        return this.commands.get(name);
    }

    @Override
    @NotNull
    public Settings<D, S> getCommandSettings() {
        return this.settings;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public Command<D, S> getDefaultCommand() {
        return this.defaultCommand;
    }

    @NotNull
    public Map<String, Command<D, S>> getCommands() {
        return this.commands;
    }

    @Nullable
    protected Command<D, S> getCommandByName(@NotNull String key) {
        return this.commands.getOrDefault(key, this.commandAliases.get(key));
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @NotNull
    protected MessageRegistry<S> getMessageRegistry() {
        return this.messageRegistry;
    }

    @NotNull
    protected Settings<D, S> getSettings() {
        return this.settings;
    }

    @NotNull
    protected SenderExtension<D, S> getSenderExtension() {
        return this.senderExtension;
    }
}

