/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.extention.Result;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.suggestion.Suggestion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplitStringInternalArgument<S>
extends StringInternalArgument<S> {
    private final String regex;
    private final InternalArgument<S, String> internalArgument;
    private final Class<?> collectionType;

    public SplitStringInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull String regex, @NotNull InternalArgument<S, String> internalArgument, @NotNull Class<?> collectionType, @NotNull Suggestion<S> suggestion, boolean optional) {
        super(meta, name, description, String.class, suggestion, optional);
        this.regex = regex;
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public @NotNull Result<@Nullable Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolve(@NotNull S sender, @NotNull String value, @Nullable Object provided) {
        Stream<Object> stream = Arrays.stream(value.split(this.regex)).map(arg -> this.internalArgument.resolve(sender, (String)arg));
        if (this.collectionType == Set.class) {
            return this.success(stream.collect(Collectors.toSet()));
        }
        return this.success(stream.collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String peek = arguments.peekLast();
        String last = peek == null ? "" : peek;
        List<String> split = Arrays.asList(last.split(this.regex));
        if (split.size() == 0) {
            return Collections.emptyList();
        }
        String current = last.endsWith(this.regex) ? "" : split.get(split.size() - 1);
        String joined = String.join((CharSequence)this.regex, current.isEmpty() ? split : split.subList(0, split.size() - 1));
        String map = joined.isEmpty() ? "" : joined + this.regex;
        return this.getSuggestion().getSuggestions(sender, current, new ArrayList<String>(arguments)).stream().map(it -> map + it).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String toString() {
        return "SplitArgument{super=" + super.toString() + "}";
    }
}

