/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.extention.Result;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.util.EnumUtils;
import java.lang.ref.WeakReference;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumInternalArgument<S>
extends StringInternalArgument<S> {
    private final Class<? extends Enum<?>> enumType;

    public EnumInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Class<? extends Enum<?>> type, @NotNull Suggestion<S> suggestion, boolean optional) {
        super(meta, name, description, type, suggestion, optional);
        this.enumType = type;
        EnumUtils.populateCache(type);
    }

    @Override
    @NotNull
    public @NotNull Result<Object, BiFunction<@NotNull CommandMeta, @NotNull String, @NotNull InvalidArgumentContext>> resolve(@NotNull S sender, @NotNull String value, @Nullable Object provided) {
        WeakReference<Enum<?>> reference = EnumUtils.getEnumConstants(this.enumType).get(value.toUpperCase());
        if (reference == null) {
            return this.invalid((meta, syntax) -> new InvalidArgumentContext((CommandMeta)meta, (String)syntax, value, this.getName(), this.getType()));
        }
        Enum enumValue = (Enum)reference.get();
        if (enumValue == null) {
            return this.invalid((commands, arguments) -> new InvalidArgumentContext((CommandMeta)commands, (String)arguments, value, this.getName(), this.getType()));
        }
        return this.success(enumValue);
    }

    @Override
    @NotNull
    public String toString() {
        return "EnumArgument{enumType=" + this.enumType + ", super=" + super.toString() + "}";
    }
}

