/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.bukkit;

import com.google.common.collect.ImmutableSet;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.core.extention.ValidationResult;
import dev.triumphteam.cmd.core.extention.meta.CommandMeta;
import dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.MessageContext;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class BukkitSenderExtension
implements SenderExtension.Default<CommandSender> {
    BukkitSenderExtension() {
    }

    @Override
    @NotNull
    public @NotNull Set<Class<? extends @NotNull CommandSender>> getAllowedSenders() {
        return ImmutableSet.of(CommandSender.class, ConsoleCommandSender.class, Player.class);
    }

    @Override
    @NotNull
    public @NotNull ValidationResult<@NotNull MessageKey<@NotNull MessageContext>> validate(@NotNull CommandMeta meta, @NotNull Class<?> allowedSender, @NotNull CommandSender sender) {
        if (Player.class.isAssignableFrom(allowedSender) && !(sender instanceof Player)) {
            return this.invalid(BukkitMessageKey.PLAYER_ONLY);
        }
        if (ConsoleCommandSender.class.isAssignableFrom(allowedSender) && !(sender instanceof ConsoleCommandSender)) {
            return this.invalid(BukkitMessageKey.CONSOLE_ONLY);
        }
        return this.valid();
    }
}

