/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.bukkit;

import dev.triumphteam.cmd.bukkit.CommandPermission;
import dev.triumphteam.cmd.bukkit.PermissionProcessor;
import dev.triumphteam.cmd.core.extention.CommandOptions;
import dev.triumphteam.cmd.core.extention.defaults.DefaultArgumentValidator;
import dev.triumphteam.cmd.core.extention.defaults.DefaultCommandExecutor;
import dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

public final class BukkitCommandOptions<S>
extends CommandOptions<CommandSender, S> {
    public BukkitCommandOptions(@NotNull SenderExtension<CommandSender, S> senderExtension, @NotNull Builder<S> builder) {
        super(senderExtension, builder);
    }

    public static final class Builder<S>
    extends CommandOptions.Builder<CommandSender, S, BukkitCommandOptions<S>, Setup<S>, Builder<S>> {
        private CommandPermission globalPermission = null;

        public Builder(@NotNull RegistryContainer<CommandSender, S> registryContainer) {
            super(new Setup<S>(registryContainer));
            this.extensions(extension -> {
                extension.setArgumentValidator(new DefaultArgumentValidator());
                extension.setCommandExecutor(new DefaultCommandExecutor());
            });
        }

        public Builder<S> setGlobalPermission(@NotNull CommandPermission commandPermission) {
            this.globalPermission = commandPermission;
            return this;
        }

        public Builder<S> setGlobalPermission(@NotNull List<String> nodes, @NotNull String description, @NotNull PermissionDefault permissionDefault) {
            return this.setGlobalPermission(new CommandPermission(nodes, description, permissionDefault));
        }

        @Override
        @NotNull
        public BukkitCommandOptions<S> build(@NotNull SenderExtension<CommandSender, S> senderExtension) {
            this.extensions(extension -> extension.addProcessor(new PermissionProcessor(this.globalPermission)));
            return new BukkitCommandOptions<S>(senderExtension, this);
        }
    }

    public static final class Setup<S>
    extends CommandOptions.Setup<CommandSender, S, Setup<S>> {
        public Setup(@NotNull RegistryContainer<CommandSender, S> registryContainer) {
            super(registryContainer);
        }
    }
}

