/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.bukkit;

import dev.triumphteam.cmd.bukkit.BukkitCommand;
import dev.triumphteam.cmd.bukkit.BukkitCommandOptions;
import dev.triumphteam.cmd.bukkit.BukkitSenderExtension;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.core.CommandManager;
import dev.triumphteam.cmd.core.command.RootCommand;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extention.registry.MessageRegistry;
import dev.triumphteam.cmd.core.extention.registry.RegistryContainer;
import dev.triumphteam.cmd.core.extention.sender.SenderExtension;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.processor.RootCommandProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class BukkitCommandManager<S>
extends CommandManager<CommandSender, S, BukkitCommandOptions<S>> {
    private final Plugin plugin;
    private final RegistryContainer<CommandSender, S> registryContainer;
    private final Map<String, BukkitCommand<S>> commands = new HashMap<String, BukkitCommand<S>>();
    private final CommandMap commandMap;
    private final Map<String, Command> bukkitCommands;

    private BukkitCommandManager(@NotNull Plugin plugin, @NotNull BukkitCommandOptions<S> commandOptions, @NotNull RegistryContainer<CommandSender, S> registryContainer) {
        super(commandOptions);
        this.plugin = plugin;
        this.registryContainer = registryContainer;
        this.commandMap = BukkitCommandManager.getCommandMap();
        this.bukkitCommands = BukkitCommandManager.getBukkitCommands(this.commandMap);
        this.registerArgument(Material.class, (S sender, String arg) -> Material.matchMaterial((String)arg));
        this.registerArgument(Player.class, (S sender, String arg) -> Bukkit.getPlayer((String)arg));
        this.registerArgument(World.class, (S sender, String arg) -> Bukkit.getWorld((String)arg));
        this.registerSuggestion(Player.class, (S sender, List<String> arguments) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <S> BukkitCommandManager<S> create(@NotNull Plugin plugin, @NotNull SenderExtension<CommandSender, S> senderExtension, @NotNull Consumer<BukkitCommandOptions.Builder<S>> builder) {
        RegistryContainer registryContainer = new RegistryContainer();
        BukkitCommandOptions.Builder extensionBuilder = new BukkitCommandOptions.Builder(registryContainer);
        builder.accept(extensionBuilder);
        return new BukkitCommandManager(plugin, extensionBuilder.build((SenderExtension)senderExtension), registryContainer);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BukkitCommandManager<CommandSender> create(@NotNull Plugin plugin) {
        return BukkitCommandManager.create(plugin, builder -> {});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static BukkitCommandManager<CommandSender> create(@NotNull Plugin plugin, @NotNull Consumer<BukkitCommandOptions.Builder<CommandSender>> builder) {
        RegistryContainer registryContainer = new RegistryContainer();
        BukkitCommandOptions.Builder extensionBuilder = new BukkitCommandOptions.Builder(registryContainer);
        MessageRegistry<CommandSender> messageRegistry = registryContainer.getMessageRegistry();
        BukkitCommandManager.setUpDefaults(messageRegistry);
        builder.accept(extensionBuilder);
        return new BukkitCommandManager<CommandSender>(plugin, (BukkitCommandOptions<CommandSender>)extensionBuilder.build((SenderExtension)new BukkitSenderExtension()), registryContainer);
    }

    private static void setUpDefaults(@NotNull MessageRegistry<CommandSender> messageRegistry) {
        messageRegistry.register(MessageKey.UNKNOWN_COMMAND, (sender, context) -> sender.sendMessage("Unknown command: `" + context.getInvalidInput() + "`."));
        messageRegistry.register(MessageKey.TOO_MANY_ARGUMENTS, (sender, context) -> sender.sendMessage("Invalid usage."));
        messageRegistry.register(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> sender.sendMessage("Invalid usage."));
        messageRegistry.register(MessageKey.INVALID_ARGUMENT, (sender, context) -> sender.sendMessage("Invalid argument `" + context.getInvalidInput() + "` for type `" + context.getArgumentType().getSimpleName() + "`."));
        messageRegistry.register(BukkitMessageKey.NO_PERMISSION, (sender, context) -> sender.sendMessage("You do not have permission to perform this command."));
        messageRegistry.register(BukkitMessageKey.PLAYER_ONLY, (sender, context) -> sender.sendMessage("This command can only be used by players."));
        messageRegistry.register(BukkitMessageKey.CONSOLE_ONLY, (sender, context) -> sender.sendMessage("This command can only be used by the console."));
    }

    @Override
    public void registerCommand(@NotNull Object command) {
        RootCommandProcessor processor = new RootCommandProcessor(command, this.getRegistryContainer(), this.getCommandOptions());
        String name = processor.getName();
        BukkitCommand bukkitCommand = this.commands.computeIfAbsent(name, it -> this.createAndRegisterCommand(processor, name));
        RootCommand rootCommand = bukkitCommand.getRootCommand();
        rootCommand.addCommands(command, processor.commands(rootCommand));
    }

    @Override
    public void unregisterCommand(@NotNull Object command) {
    }

    @Override
    @NotNull
    protected RegistryContainer<CommandSender, S> getRegistryContainer() {
        return this.registryContainer;
    }

    @NotNull
    private BukkitCommand<S> createAndRegisterCommand(@NotNull RootCommandProcessor<CommandSender, S> processor, @NotNull String name) {
        Command oldCommand = this.commandMap.getCommand(name);
        if (oldCommand instanceof PluginIdentifiableCommand && ((PluginIdentifiableCommand)oldCommand).getPlugin() == this.plugin) {
            this.bukkitCommands.remove(name);
            oldCommand.unregister(this.commandMap);
        }
        BukkitCommand<S> newCommand = new BukkitCommand<S>(processor);
        this.commandMap.register(this.plugin.getName(), newCommand);
        return newCommand;
    }

    @NotNull
    private static CommandMap getCommandMap() {
        try {
            Server server = Bukkit.getServer();
            Method getCommandMap = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            getCommandMap.setAccessible(true);
            return (CommandMap)getCommandMap.invoke((Object)server, new Object[0]);
        }
        catch (Exception ignored) {
            throw new CommandRegistrationException("Unable get Command Map. Commands will not be registered!");
        }
    }

    @NotNull
    private static @NotNull Map<String, @NotNull Command> getBukkitCommands(@NotNull CommandMap commandMap) {
        try {
            Field bukkitCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            bukkitCommands.setAccessible(true);
            return (Map)bukkitCommands.get(commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CommandRegistrationException("Unable get Bukkit commands. Commands might not be registered correctly!");
        }
    }
}

