/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.menus;

import com.badbones69.crazycrates.paper.api.builders.gui.DynamicInventoryBuilder;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.interfaces.GuiFiller;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.types.PaginatedGui;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CratePreviewMenu
extends DynamicInventoryBuilder {
    private final Tier tier;
    private final Player player = this.getPlayer();
    private final PaginatedGui gui = this.getGui();

    public CratePreviewMenu(Player player, Crate crate, Tier tier) {
        super(player, crate, crate.getPreviewName(), crate.getPreviewChestLines());
        this.tier = tier;
    }

    @Override
    public void open() {
        Crate crate = this.getCrate();
        if (crate == null) {
            return;
        }
        if (crate.isBorderToggle()) {
            GuiFiller guiFiller = this.gui.getFiller();
            GuiItem guiItem = new GuiItem(crate.getBorderItem().asItemStack());
            guiFiller.fillTop(guiItem);
            guiFiller.fillBottom(guiItem);
        }
        UUID uuid = this.player.getUniqueId();
        crate.getPreviewItems(this.player, this.tier).forEach(itemStack -> this.gui.addItem(new GuiItem((ItemStack)itemStack)));
        this.gui.setOpenGuiAction(event -> this.inventoryManager.addPreviewViewer(uuid));
        this.gui.setCloseGuiAction(event -> this.inventoryManager.removePreviewViewer(uuid));
        this.gui.open(this.player, gui -> {
            int rows = gui.getRows();
            this.setBackButton(rows, 4, true);
            this.setNextButton(rows, 6, true);
            this.addMenuButton(this.player, crate, this.gui, rows, 5);
        });
    }
}

