/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.sound.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class WonderCrate
extends CrateBuilder {
    private final CrateManager crateManager;
    private final BukkitUserManager userManager;
    private final Inventory inventory;
    private final Player player;
    private final UUID uuid;
    private final Crate crate;

    public WonderCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
        this.crateManager = this.plugin.getCrateManager();
        this.userManager = this.plugin.getUserManager();
        this.inventory = this.getInventory();
        this.player = this.getPlayer();
        this.uuid = this.player.getUniqueId();
        this.crate = this.getCrate();
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.getPlayer());
            return;
        }
        final ArrayList<String> slots = new ArrayList<String>();
        for (int index = 0; index < this.getSize(); ++index) {
            Prize prize = this.crate.pickPrize(this.player);
            slots.add(String.valueOf(index));
            this.setItem(index, prize.getDisplayItem(this.player, this.crate));
        }
        this.player.openInventory(this.inventory);
        this.addCrateTask(new FoliaScheduler(null, (Entity)this.player){
            int time;
            int full;
            int slot1;
            int slot2;
            final List<Integer> other;
            Prize prize;
            {
                super(arg0, arg1);
                this.time = 0;
                this.full = 0;
                this.slot1 = 0;
                this.slot2 = 44;
                this.other = new ArrayList<Integer>();
                this.prize = null;
            }

            @Override
            public void run() {
                if (this.time >= 2 && this.full <= 65) {
                    slots.remove("" + this.slot1);
                    slots.remove("" + this.slot2);
                    this.other.add(this.slot1);
                    this.other.add(this.slot2);
                    ItemStack material = ((LegacyItemBuilder)new LegacyItemBuilder((ItemType)(WonderCrate.this.crate.isGlassBorderToggled() ? ItemType.BLACK_STAINED_GLASS_PANE : ItemType.AIR)).setDisplayName(" ")).asItemStack();
                    WonderCrate.this.setItem(this.slot1, material);
                    WonderCrate.this.setItem(this.slot2, material);
                    for (String slot : slots) {
                        this.prize = WonderCrate.this.crate.pickPrize(WonderCrate.this.player);
                        WonderCrate.this.setItem(Integer.parseInt(slot), this.prize.getDisplayItem(WonderCrate.this.player, WonderCrate.this.crate));
                    }
                    WonderCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                    ++this.slot1;
                    --this.slot2;
                }
                if (this.full > 67) {
                    if (WonderCrate.this.crate.isGlassBorderToggled()) {
                        for (int slot : this.other) {
                            WonderCrate.this.setCustomGlassPane(slot);
                        }
                    }
                    WonderCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                }
                WonderCrate.this.player.openInventory(WonderCrate.this.getInventory());
                if (this.full > 100) {
                    WonderCrate.this.crateManager.endCrate(WonderCrate.this.player);
                    WonderCrate.this.player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                    if (WonderCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(WonderCrate.this.crate, WonderCrate.this.player)) {
                        new CrateSpinMenu(WonderCrate.this.player, new GuiSettings(WonderCrate.this.crate, this.prize, FileKeys.respin_gui.getConfiguration())).open();
                        WonderCrate.this.crateManager.removePlayerFromOpeningList(WonderCrate.this.player);
                        return;
                    }
                    WonderCrate.this.userManager.removeRespinPrize(WonderCrate.this.uuid, fileName);
                    if (!WonderCrate.this.crate.isCyclePersistRestart()) {
                        WonderCrate.this.userManager.removeRespinCrate(WonderCrate.this.uuid, fileName, WonderCrate.this.userManager.getCrateRespin(WonderCrate.this.uuid, fileName));
                    }
                    PrizeManager.givePrize(WonderCrate.this.player, WonderCrate.this.crate, this.prize);
                    WonderCrate.this.playSound("stop-sound", Sound.Source.MASTER, "entity.player.levelup");
                    WonderCrate.this.crateManager.removePlayerFromOpeningList(WonderCrate.this.player);
                    return;
                }
                ++this.full;
                ++this.time;
                if (this.time > 2) {
                    this.time = 0;
                }
            }
        }.runAtFixedRate(0L, 2L));
    }
}

