/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class WarCrate
extends CrateBuilder {
    private final Map<Material, String> colorCodes = new HashMap<Material, String>();
    private final Inventory inventory = this.getInventory();
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public WarCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCloser(this.player);
            this.crateManager.removePicker(this.player);
            return;
        }
        this.crateManager.addPicker(this.player, false);
        this.crateManager.addCloser(this.player, false);
        this.setRandomPrizes();
        this.player.openInventory(this.inventory);
        this.addCrateTask(new FoliaScheduler(null, (Entity)this.player){
            int full;
            int open;
            {
                this.full = 0;
                this.open = 0;
            }

            @Override
            public void run() {
                if (this.full < 25) {
                    WarCrate.this.setRandomPrizes();
                    WarCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.lava.pop");
                }
                ++this.open;
                if (this.open >= 3) {
                    WarCrate.this.player.updateInventory();
                    this.open = 0;
                }
                ++this.full;
                if (this.full == 26) {
                    WarCrate.this.playSound("stop-sound", Sound.Source.MASTER, "block.lava.pop");
                    WarCrate.this.setRandomGlass();
                    WarCrate.this.crateManager.addPicker(WarCrate.this.player, true);
                }
            }
        }.runAtFixedRate(1L, 3L));
    }

    private void setRandomPrizes() {
        if (!this.crateManager.isInOpeningList(this.player) && !(this.inventory.getHolder(false) instanceof CratePrizeMenu)) {
            return;
        }
        for (int index = 0; index < 9; ++index) {
            this.setItem(index, this.crate.pickPrize(this.player).getDisplayItem(this.player, this.crate));
        }
    }

    private void setRandomGlass() {
        if (this.crate.isGlassBorderToggled()) {
            return;
        }
        Player player = this.getPlayer();
        if (!this.crateManager.isInOpeningList(player) && !(this.inventory.getHolder(false) instanceof CratePrizeMenu)) {
            return;
        }
        if (this.colorCodes.isEmpty()) {
            this.getColorCode();
        }
        LegacyItemBuilder builder = MiscUtils.getRandomPaneColor();
        builder.setDisplayName("<" + this.colorCodes.get(builder.getType()) + "><bold>???</bold>");
        ItemStack item = builder.asItemStack();
        for (int index = 0; index < 9; ++index) {
            this.setItem(index, item);
        }
    }

    private void getColorCode() {
        this.colorCodes.put(Material.WHITE_STAINED_GLASS_PANE, "white");
        this.colorCodes.put(Material.ORANGE_STAINED_GLASS_PANE, "gold");
        this.colorCodes.put(Material.MAGENTA_STAINED_GLASS_PANE, "light_purple");
        this.colorCodes.put(Material.LIGHT_BLUE_STAINED_GLASS_PANE, "dark_aqua");
        this.colorCodes.put(Material.YELLOW_STAINED_GLASS_PANE, "yellow");
        this.colorCodes.put(Material.LIME_STAINED_GLASS_PANE, "green");
        this.colorCodes.put(Material.PINK_STAINED_GLASS_PANE, "red");
        this.colorCodes.put(Material.GRAY_STAINED_GLASS_PANE, "dark_gray");
        this.colorCodes.put(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "gray");
        this.colorCodes.put(Material.CYAN_STAINED_GLASS_PANE, "aqua");
        this.colorCodes.put(Material.PURPLE_STAINED_GLASS_PANE, "dark_purple");
        this.colorCodes.put(Material.BLUE_STAINED_GLASS_PANE, "dark_blue");
        this.colorCodes.put(Material.BROWN_STAINED_GLASS_PANE, "gold");
        this.colorCodes.put(Material.GREEN_STAINED_GLASS_PANE, "green");
        this.colorCodes.put(Material.RED_STAINED_GLASS_PANE, "dark_red");
        this.colorCodes.put(Material.BLACK_STAINED_GLASS_PANE, "black");
    }
}

