/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CsgoCrate
extends CrateBuilder {
    private final CrateManager crateManager;
    private final BukkitUserManager userManager;
    private final Inventory inventory;
    private final Player player;
    private final UUID uuid;
    private final Crate crate;

    public CsgoCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
        this.crateManager = this.plugin.getCrateManager();
        this.userManager = this.plugin.getUserManager();
        this.inventory = this.getInventory();
        this.player = this.getPlayer();
        this.uuid = this.player.getUniqueId();
        this.crate = this.getCrate();
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.populate();
        this.player.openInventory(this.inventory);
        this.addCrateTask(new FoliaScheduler(null, (Entity)this.player){
            int time;
            int full;
            int open;
            {
                super(arg0, arg1);
                this.time = 1;
                this.full = 0;
                this.open = 0;
            }

            @Override
            public void run() {
                if (this.full <= 50) {
                    CsgoCrate.this.moveItemsAndSetGlass();
                    CsgoCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                }
                ++this.open;
                if (this.open >= 5) {
                    CsgoCrate.this.player.openInventory(CsgoCrate.this.inventory);
                    this.open = 0;
                }
                ++this.full;
                if (this.full > 51) {
                    if (MiscUtils.slowSpin(120, 15).contains(this.time)) {
                        CsgoCrate.this.moveItemsAndSetGlass();
                        CsgoCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                    }
                    ++this.time;
                    if (this.time == 60) {
                        CsgoCrate.this.playSound("stop-sound", Sound.Source.MASTER, "entity.player.levelup");
                        CsgoCrate.this.crateManager.endCrate(CsgoCrate.this.player);
                        String material = CsgoCrate.this.config.getProperty(ConfigKeys.crate_csgo_finished_material);
                        ItemStack itemStack = ((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder().withType(material.isEmpty() ? Material.GRAY_STAINED_GLASS.getKey().getKey() : material)).setDisplayName(" ")).asItemStack();
                        CsgoCrate.this.setItem(4, itemStack);
                        CsgoCrate.this.setItem(22, itemStack);
                        ItemStack item = CsgoCrate.this.inventory.getItem(13);
                        if (item != null) {
                            Prize prize = CsgoCrate.this.crate.getPrize(item);
                            if (CsgoCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(CsgoCrate.this.crate, CsgoCrate.this.player)) {
                                new CrateSpinMenu(CsgoCrate.this.player, new GuiSettings(CsgoCrate.this.crate, prize, FileKeys.respin_gui.getConfiguration())).open();
                                return;
                            }
                            CsgoCrate.this.userManager.removeRespinPrize(CsgoCrate.this.uuid, fileName);
                            if (!CsgoCrate.this.crate.isCyclePersistRestart()) {
                                CsgoCrate.this.userManager.removeRespinCrate(CsgoCrate.this.uuid, fileName, CsgoCrate.this.userManager.getCrateRespin(CsgoCrate.this.uuid, fileName));
                            }
                            PrizeManager.givePrize(CsgoCrate.this.player, CsgoCrate.this.crate, prize);
                        }
                        CsgoCrate.this.crateManager.removePlayerFromOpeningList(CsgoCrate.this.player);
                        new FoliaScheduler(null, (Entity)CsgoCrate.this.player){

                            @Override
                            public void run() {
                                if (CsgoCrate.this.player.getOpenInventory().getTopInventory().equals((Object)CsgoCrate.this.inventory)) {
                                    CsgoCrate.this.player.closeInventory();
                                }
                            }
                        }.runDelayed(40L);
                        this.cancel();
                    } else if (this.time > 60) {
                        this.cancel();
                    }
                }
            }
        }.runAtFixedRate(0L, 1L));
    }

    private void populate() {
        String material;
        if (this.crate.isGlassBorderToggled()) {
            this.getBorder().forEach(this::setCustomGlassPane);
        }
        if (!(material = this.config.getProperty(ConfigKeys.crate_csgo_cycling_material)).isEmpty()) {
            ItemStack itemStack = ((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder().withType(material)).setDisplayName(" ")).asItemStack();
            this.setItem(4, itemStack);
            this.setItem(22, itemStack);
        }
        for (int index = 9; index > 8 && index < 18; ++index) {
            this.setItem(index, this.crate.pickPrize(this.player).getDisplayItem(this.player, this.crate));
        }
    }

    private void moveItemsAndSetGlass() {
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = 9; i > 8 && i < 17; ++i) {
            items.add(this.inventory.getItem(i));
        }
        this.setItem(9, this.crate.pickPrize(this.player).getDisplayItem(this.player, this.crate));
        for (i = 0; i < 8; ++i) {
            this.setItem(i + 10, (ItemStack)items.get(i));
        }
        if (this.crate.isGlassBorderToggled()) {
            this.getBorder().forEach(this::setCustomGlassPane);
        }
    }

    private List<Integer> getBorder() {
        String material = this.config.getProperty(ConfigKeys.crate_csgo_cycling_material);
        if (!material.isEmpty()) {
            return Arrays.asList(0, 1, 2, 3, 5, 6, 7, 8, 18, 19, 20, 21, 23, 24, 25, 26);
        }
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 18, 19, 20, 21, 22, 23, 24, 25, 26);
    }
}

