/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateOnTheGo
extends CrateBuilder {
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public CrateOnTheGo(@NotNull Crate crate, @NotNull Player player) {
        super(crate, player);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, KeyType.physical_key, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, true);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        Prize prize = this.crate.pickPrize(this.player);
        if (this.crate.isCyclePrize() && !PrizeManager.isCapped(this.crate, this.player)) {
            new CrateSpinMenu(this.player, new GuiSettings(this.crate, prize, FileKeys.respin_gui.getConfiguration())).open();
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removePlayerKeyType(this.player);
            return;
        }
        this.userManager.removeRespinPrize(this.uuid, fileName);
        if (!this.crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(this.uuid, fileName, this.userManager.getCrateRespin(this.uuid, fileName));
        }
        PrizeManager.givePrize(this.player, this.crate, prize);
        this.crateManager.removePlayerKeyType(this.player);
    }
}

