/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.other.quadcrates.structures;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.tasks.crates.other.quadcrates.structures.IStructureManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureManager
implements IStructureManager {
    private final Set<Location> postStructurePasteBlocks = new HashSet<Location>();
    private final Set<Location> preStructurePasteBlocks = new HashSet<Location>();
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final boolean isVerbose = MiscUtils.isLogging();
    private File file = null;
    private Structure structure = null;
    private boolean doNotApply = false;

    @Override
    public void applyStructure(@Nullable File file) {
        if (file == null) {
            this.doNotApply = true;
            return;
        }
        this.file = file;
        this.structure = CompletableFuture.supplyAsync(() -> {
            try {
                return this.plugin.getServer().getStructureManager().loadStructure(this.file);
            }
            catch (IOException exception) {
                if (this.isVerbose) {
                    this.logger.error("Failed to load structure: {}!", (Object)this.file.getName(), (Object)exception);
                }
                return null;
            }
        }).join();
    }

    @Override
    @NotNull
    public org.bukkit.structure.StructureManager getStructureManager() {
        return this.plugin.getServer().getStructureManager();
    }

    @Override
    public void saveStructure(@Nullable File file, @Nullable Location one, @Nullable Location two, boolean includeEntities) {
        block4: {
            if (this.doNotApply) {
                return;
            }
            if (file == null || one == null || two == null) {
                return;
            }
            this.structure.fill(one, two, includeEntities);
            try {
                this.getStructureManager().saveStructure(file, this.structure);
            }
            catch (IOException exception) {
                if (!this.isVerbose) break block4;
                this.logger.error("Failed to save structure to: {}!", (Object)file.getName(), (Object)exception);
            }
        }
    }

    @Override
    public void pasteStructure(@Nullable Location location, boolean storeBlocks) {
        block6: {
            if (this.doNotApply) {
                return;
            }
            if (location == null) {
                return;
            }
            try {
                if (storeBlocks) {
                    this.getBlocks(location);
                }
                Location clonedLocation = location.clone().subtract(2.0, 0.0, 2.0);
                this.structure.place(clonedLocation, false, StructureRotation.NONE, Mirror.NONE, 0, 1.0f, (Random)ThreadLocalRandom.current());
                if (storeBlocks) {
                    this.getStructureBlocks(clonedLocation);
                }
            }
            catch (Exception exception) {
                if (!this.isVerbose) break block6;
                this.logger.error("Could not paste structure", (Throwable)exception);
            }
        }
    }

    @Override
    public void removeStructure() {
        if (this.doNotApply) {
            return;
        }
        this.postStructurePasteBlocks.forEach(block -> {
            if (block.getBlock().getType() != Material.AIR) {
                Location location = block.toBlockLocation();
                location.getBlock().setType(Material.AIR, true);
            }
        });
    }

    private void getStructureBlocks(@NotNull Location location) {
        int x = 0;
        while ((double)x < this.getStructureX()) {
            int y = 0;
            while ((double)y < this.getStructureY()) {
                int z = 0;
                while ((double)z < this.getStructureZ()) {
                    Block relativeLocation = location.getBlock().getRelative(x, y, z);
                    this.postStructurePasteBlocks.add(relativeLocation.getLocation());
                    this.postStructurePasteBlocks.forEach(block -> {
                        Location blockLoc = block.toBlockLocation();
                        blockLoc.getBlock().getState().update();
                    });
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    @NotNull
    public Set<Location> getBlocks(@Nullable Location location) {
        if (this.doNotApply) {
            return Collections.emptySet();
        }
        if (location == null) {
            return this.getNearbyBlocks();
        }
        int x = 0;
        while ((double)x < this.getStructureX()) {
            int y = 0;
            while ((double)y < this.getStructureY()) {
                int z = 0;
                while ((double)z < this.getStructureZ()) {
                    Block relativeLocation = location.getBlock().getRelative(x, y, z).getLocation().subtract(2.0, 0.0, 2.0).getBlock();
                    this.preStructurePasteBlocks.add(relativeLocation.getLocation());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return this.getNearbyBlocks();
    }

    @Override
    public double getStructureX() {
        if (this.doNotApply) {
            return 0.0;
        }
        return this.structure.getSize().getX();
    }

    @Override
    public double getStructureY() {
        if (this.doNotApply) {
            return 0.0;
        }
        return this.structure.getSize().getY();
    }

    @Override
    public double getStructureZ() {
        if (this.doNotApply) {
            return 0.0;
        }
        return this.structure.getSize().getZ();
    }

    @Override
    @NotNull
    public Set<Location> getNearbyBlocks() {
        return Collections.unmodifiableSet(this.preStructurePasteBlocks);
    }

    @Override
    @NotNull
    public List<Material> getBlockBlacklist() {
        return Lists.newArrayList((Object[])new Material[]{Material.OAK_SIGN, Material.SPRUCE_SIGN, Material.BIRCH_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.CHERRY_SIGN, Material.DARK_OAK_SIGN, Material.MANGROVE_SIGN, Material.BAMBOO_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.OAK_HANGING_SIGN, Material.SPRUCE_HANGING_SIGN, Material.BIRCH_HANGING_SIGN, Material.JUNGLE_HANGING_SIGN, Material.ACACIA_HANGING_SIGN, Material.CHERRY_HANGING_SIGN, Material.DARK_OAK_HANGING_SIGN, Material.MANGROVE_HANGING_SIGN, Material.BAMBOO_HANGING_SIGN, Material.CRIMSON_HANGING_SIGN, Material.WARPED_HANGING_SIGN, Material.STONE_BUTTON, Material.POLISHED_BLACKSTONE_BUTTON, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.CHERRY_BUTTON, Material.DARK_OAK_BUTTON, Material.MANGROVE_BUTTON, Material.BAMBOO_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON});
    }

    @Override
    public void createStructure() {
        this.structure = this.getStructureManager().createStructure();
    }

    @Override
    @NotNull
    public File getStructureFile() {
        return this.file;
    }
}

