/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support.holograms.types;

import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import java.util.ArrayList;
import libs.com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Server;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class FancyHologramsSupport
extends HologramManager {
    private final de.oliver.fancyholograms.api.HologramManager manager = FancyHologramsPlugin.get().getHologramManager();

    @Override
    public void createHologram(Location location, Crate crate, String id) {
        Color background;
        if (crate.getCrateType() == CrateType.menu) {
            return;
        }
        CrateHologram crateHologram = crate.getHologram();
        if (!crateHologram.isEnabled()) {
            this.removeHologram(id);
            return;
        }
        if (this.exists(id)) {
            return;
        }
        String color = crateHologram.getBackgroundColor();
        if (color.equalsIgnoreCase("transparent")) {
            background = Hologram.TRANSPARENT;
        } else if (color.startsWith("#")) {
            Color parsed = Color.fromARGB((int)((int)Long.parseLong(color.substring(1), 16)));
            background = color.length() == 7 ? parsed.setAlpha(255) : parsed;
        } else {
            NamedTextColor textColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)color.replace(' ', '_'));
            background = textColor == null ? null : Color.fromARGB((int)(textColor.value() | 0xC8000000));
        }
        TextHologramData hologramData = new TextHologramData(this.name(id), location.clone().add(this.getVector(crate))).setBackground(background);
        hologramData.setText(crateHologram.getMessages());
        if (crateHologram.getUpdateInterval() != -1) {
            hologramData.setTextUpdateInterval(crateHologram.getUpdateInterval());
        }
        final Hologram hologram = this.manager.create((HologramData)hologramData);
        hologram.createHologram();
        final Server server = this.plugin.getServer();
        new FoliaScheduler(this, Scheduler.async_scheduler){

            @Override
            public void run() {
                server.getOnlinePlayers().forEach(arg_0 -> ((Hologram)hologram).updateShownStateFor(arg_0));
            }
        }.run();
        this.manager.addHologram(hologram);
    }

    @Override
    public void removeHologram(String id) {
        Hologram hologram = this.manager.getHologram(this.name(id)).orElse(null);
        if (hologram == null) {
            return;
        }
        FancyHologramsPlugin.get().getHologramThread().submit(() -> this.manager.removeHologram(hologram));
    }

    @Override
    public boolean exists(String id) {
        return this.manager.getHologram(this.name(id)).orElse(null) != null;
    }

    @Override
    public void purge(boolean isShutdown) {
        final String name = this.plugin.getName().toLowerCase();
        ArrayList<String> holograms = new ArrayList<String>(){
            {
                FancyHologramsSupport.this.manager.getHolograms().forEach((? super T hologram) -> {
                    String id = hologram.getName();
                    if (id.startsWith(name + "-")) {
                        this.add(id.replace(name + "-", ""));
                    }
                });
            }
        };
        holograms.forEach(this::removeHologram);
    }

    @Override
    public final String getName() {
        return "FancyHolograms";
    }
}

