/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support.holograms.types;

import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class DecentHologramsSupport
extends HologramManager {
    private final Map<String, Hologram> holograms = new HashMap<String, Hologram>();

    @Override
    public void createHologram(Location location, Crate crate, String id) {
        if (crate.getCrateType() == CrateType.menu) {
            return;
        }
        CrateHologram crateHologram = crate.getHologram();
        if (!crateHologram.isEnabled()) {
            this.removeHologram(id);
            return;
        }
        if (this.exists(id)) {
            return;
        }
        Hologram hologram = DHAPI.createHologram((String)this.name(id), (Location)location.clone().add(this.getVector(crate)));
        crateHologram.getMessages().forEach(line -> {
            String coloredLine;
            if (line != null && (coloredLine = this.color((String)line)) != null) {
                DHAPI.addHologramLine((Hologram)hologram, (String)coloredLine);
            }
        });
        hologram.setDisplayRange(crateHologram.getRange());
        if (crateHologram.getUpdateInterval() != -1) {
            hologram.setUpdateInterval(crateHologram.getUpdateInterval());
        }
        this.holograms.putIfAbsent(this.name(id), hologram);
    }

    @Override
    public void removeHologram(String id) {
        DHAPI.removeHologram((String)this.name(id));
    }

    @Override
    public boolean exists(String id) {
        return DHAPI.getHologram((String)this.name(id)) != null;
    }

    @Override
    public void purge(boolean isShutdown) {
        this.holograms.forEach((key, value) -> {
            this.removeHologram((String)key);
            value.delete();
        });
        this.holograms.clear();
    }

    @Override
    public final String getName() {
        return "DecentHolograms";
    }
}

