/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support.holograms.types;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Display.CMIBillboard;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import java.util.ArrayList;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CMIHologramsSupport
extends HologramManager {
    private final com.Zrips.CMI.Modules.Holograms.HologramManager hologramManager = CMI.getInstance().getHologramManager();

    @Override
    public void createHologram(final Location location, Crate crate, String id) {
        if (crate.getCrateType() == CrateType.menu) {
            return;
        }
        final CrateHologram crateHologram = crate.getHologram();
        if (!crateHologram.isEnabled()) {
            this.removeHologram(id);
            return;
        }
        if (this.exists(id)) {
            return;
        }
        final CMIHologram hologram = new CMIHologram(this.name(id), new CMILocation(location.clone().add(this.getVector(crate))));
        hologram.setNewDisplayMethod(true);
        hologram.setBillboard(CMIBillboard.CENTER);
        String color = crateHologram.getBackgroundColor();
        if (color.equalsIgnoreCase("transparent")) {
            hologram.setBackgroundAlpha(0);
        } else {
            hologram.setBackgroundColor(CMIChatColor.getClosest((String)color));
        }
        hologram.setShowRange(crateHologram.getRange());
        hologram.setLines(this.lines(crateHologram));
        if (crateHologram.getUpdateInterval() != -1) {
            hologram.setUpdateIntervalSec((double)crateHologram.getUpdateInterval());
        }
        this.hologramManager.addHologram(hologram);
        new FoliaScheduler(location){

            @Override
            public void run() {
                location.getNearbyEntitiesByType(Player.class, (double)crateHologram.getRange()).forEach(player -> CMIHologramsSupport.this.hologramManager.handleHoloUpdates(player, (Location)hologram.getLocation()));
            }
        }.runNow();
    }

    @Override
    public void removeHologram(String id) {
        CMIHologram hologram = this.hologramManager.getByName(this.name(id));
        if (hologram != null) {
            hologram.remove();
        }
    }

    @Override
    public boolean exists(String id) {
        return this.hologramManager.getByName(this.name(id)) != null;
    }

    @Override
    public void purge(boolean isShutdown) {
        final String name = this.plugin.getName().toLowerCase();
        ArrayList<String> holograms = new ArrayList<String>(){
            {
                CMIHologramsSupport.this.hologramManager.getHolograms().forEach((? super K id, ? super V hologram) -> {
                    if (id.startsWith(name + "-")) {
                        this.add(id.replace(name + "-", ""));
                    }
                });
            }
        };
        holograms.forEach(this::removeHologram);
    }

    @Override
    public final String getName() {
        return "CMI";
    }
}

