/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.managers.events;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import libs.com.ryderbelserion.fusion.api.utils.FileUtils;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class EventManager {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final SettingsManager config = ConfigManager.getConfig();

    public static void logEvent(EventType type, String name, CommandSender sender, Crate crate, KeyType keyType, int amount) {
        EventManager.handle(type, name, sender, crate, keyType, amount);
    }

    private static void handle(EventType type, String name, CommandSender sender, Crate crate, KeyType keyType, int amount) {
        Object message = "";
        File file = null;
        switch (type) {
            case event_key_given: 
            case event_key_removed: 
            case event_key_received: 
            case event_key_sent: 
            case event_key_taken: 
            case event_key_taken_multiple: {
                message = "Player: %player% | Sender: %sender% | Key Name: %key_name%<reset> | Key Type: %key_type%".replace("%key_type%", keyType.getFriendlyName()).replace("%player%", name).replace("%sender%", sender.getName()).replace("%key_name%", crate.getKeyName());
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = FileKeys.key_log.getFile();
                break;
            }
            case event_crate_opened: {
                message = "Player: %player% | Crate Name: %crate_name%<reset> | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name%<reset> | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", name).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "no");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = FileKeys.crate_log.getFile();
                break;
            }
            case event_crate_force_opened: {
                message = "Player: %player% | Crate Name: %crate_name%<reset> | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name%<reset> | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", name).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "yes");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                file = FileKeys.crate_log.getFile();
            }
        }
        EventManager.log((String)message, file, type);
    }

    private static void log(String message, File file, EventType type) {
        boolean log_to_console;
        boolean log_to_file = config.getProperty(ConfigKeys.log_to_file);
        String time = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(System.currentTimeMillis()));
        if (log_to_file) {
            FileUtils.write(file, "[" + time + " " + type.getEvent() + "]: " + PlainTextComponentSerializer.plainText().serialize(AdvUtils.parse(message)));
        }
        if (log_to_console = config.getProperty(ConfigKeys.log_to_console).booleanValue()) {
            plugin.getComponentLogger().info("[{} {}]: {}", new Object[]{time, type.getEvent(), AdvUtils.parse(message)});
        }
    }
}

