/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.managers;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;
import us.crazycrew.crazycrates.api.users.UserManager;

public class BukkitUserManager
extends UserManager {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final FileKeys data = FileKeys.data;

    public Player getUser(@NotNull UUID uuid) {
        return this.plugin.getServer().getPlayer(uuid);
    }

    @Override
    public int getVirtualKeys(@NotNull UUID uuid, @NotNull String crateName) {
        return this.data.getConfiguration().getInt("Players." + String.valueOf(uuid) + "." + crateName, 0);
    }

    @Override
    public void addVirtualKeys(@NotNull UUID uuid, @NotNull String crateName, int amount) {
        if (this.isPlayerNull(uuid)) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Player with the uuid: {} is null.", (Object)uuid);
            }
            return;
        }
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        String fileName = crate.getFileName();
        Player player = this.getUser(uuid);
        int keys = this.getVirtualKeys(uuid, fileName);
        YamlConfiguration configuration = this.data.getConfiguration();
        if (!configuration.contains("Players." + String.valueOf(uuid) + ".Name")) {
            configuration.set("Players." + String.valueOf(uuid) + ".Name", (Object)player.getName());
        }
        configuration.set("Players." + String.valueOf(uuid) + "." + fileName, (Object)Math.max(keys + amount, 0));
        this.data.save();
    }

    @Override
    public void setKeys(@NotNull UUID uuid, @NotNull String crateName, int amount) {
        if (this.isPlayerNull(uuid)) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Player with the uuid: {} is null.", (Object)uuid);
            }
            return;
        }
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        String fileName = crate.getFileName();
        Player player = this.getUser(uuid);
        YamlConfiguration configuration = this.data.getConfiguration();
        configuration.set("Players." + String.valueOf(player.getUniqueId()) + ".Name", (Object)player.getName());
        configuration.set("Players." + String.valueOf(player.getUniqueId()) + "." + fileName, (Object)amount);
        this.data.save();
    }

    private boolean isPlayerNull(UUID uuid) {
        return this.getUser(uuid) == null;
    }

    @Override
    public void addKeys(@NotNull UUID uuid, @NotNull String crateName, @NotNull KeyType keyType, int amount) {
        if (this.isPlayerNull(uuid)) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Player with the uuid {} is null.", (Object)uuid);
            }
            return;
        }
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        String fileName = crate.getFileName();
        Player player = this.getUser(uuid);
        SettingsManager config = ConfigManager.getConfig();
        switch (keyType) {
            case physical_key: {
                if (!MiscUtils.isInventoryFull(player)) {
                    MiscUtils.addItem(player, crate.getKey(amount, player));
                    return;
                }
                if (config.getProperty(ConfigKeys.give_virtual_keys_when_inventory_full).booleanValue()) {
                    this.addVirtualKeys(player.getUniqueId(), fileName, amount);
                    if (config.getProperty(ConfigKeys.notify_player_when_inventory_full).booleanValue()) {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("{amount}", String.valueOf(amount));
                        placeholders.put("{player}", player.getName());
                        placeholders.put("{keytype}", keyType.getFriendlyName());
                        placeholders.put("{key}", crate.getKeyName());
                        Messages.cannot_give_player_keys.sendMessage((CommandSender)player, placeholders);
                    }
                    return;
                }
                player.getWorld().dropItem(player.getLocation(), crate.getKey(amount, player));
                break;
            }
            case virtual_key: {
                this.addVirtualKeys(player.getUniqueId(), fileName, amount);
            }
        }
    }

    @Override
    public int getTotalKeys(@NotNull UUID uuid, @NotNull String crateName) {
        return this.getVirtualKeys(uuid, crateName) + this.getPhysicalKeys(uuid, crateName);
    }

    @Override
    public int getPhysicalKeys(@NotNull UUID uuid, @NotNull String crateName) {
        if (this.isPlayerNull(uuid)) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Player with the uuid {} is null.", (Object)uuid);
            }
            return 0;
        }
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return 0;
        }
        Player player = this.getUser(uuid);
        int keys = 0;
        for (ItemStack item : player.getOpenInventory().getBottomInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !ItemUtils.isSimilar(item, crate)) continue;
            keys += item.getAmount();
        }
        return keys;
    }

    @Override
    public boolean takeKeys(@NotNull UUID uuid, @NotNull String crateName, @NotNull KeyType keyType, int amount, boolean checkHand) {
        if (this.isPlayerNull(uuid)) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Player with the uuid {} is null.", (Object)uuid);
            }
            return false;
        }
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return false;
        }
        String fileName = crate.getFileName();
        Player player = this.getUser(uuid);
        switch (keyType) {
            case physical_key: {
                ItemStack item;
                int takeAmount = amount;
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (checkHand) {
                    items.add(player.getEquipment().getItemInMainHand());
                    items.add(player.getEquipment().getItemInOffHand());
                } else {
                    items.addAll(Arrays.asList(player.getInventory().getContents()));
                }
                for (ItemStack item2 : items) {
                    if (item2 == null || !ItemUtils.isSimilar(item2, crate)) continue;
                    int keyAmount = item2.getAmount();
                    if (takeAmount - keyAmount >= 0) {
                        MiscUtils.removeMultipleItemStacks((Inventory)player.getInventory(), item2);
                        if (crate.getCrateType() == CrateType.cosmic) {
                            this.addOpenedCrate(player.getUniqueId(), fileName, amount);
                        }
                        takeAmount -= keyAmount;
                    } else {
                        item2.setAmount(keyAmount - takeAmount);
                        if (crate.getCrateType() == CrateType.cosmic) {
                            this.addOpenedCrate(player.getUniqueId(), fileName, amount);
                        }
                        takeAmount = 0;
                    }
                    if (takeAmount > 0) continue;
                    return true;
                }
                if (takeAmount <= 0 || !ItemUtils.isSimilar(item = player.getEquipment().getItemInOffHand(), crate)) break;
                int keyAmount = item.getAmount();
                if (takeAmount - keyAmount >= 0) {
                    player.getEquipment().setItemInOffHand(null);
                    takeAmount -= keyAmount;
                    if (crate.getCrateType() == CrateType.cosmic) {
                        this.addOpenedCrate(player.getUniqueId(), fileName, amount);
                    }
                } else {
                    item.setAmount(keyAmount - takeAmount);
                    if (crate.getCrateType() == CrateType.cosmic) {
                        this.addOpenedCrate(player.getUniqueId(), fileName, amount);
                    }
                    takeAmount = 0;
                }
                if (takeAmount > 0) break;
                return true;
            }
            case virtual_key: {
                int keys = this.getVirtualKeys(uuid, fileName);
                YamlConfiguration configuration = this.data.getConfiguration();
                configuration.set("Players." + String.valueOf(uuid) + ".Name", (Object)player.getName());
                int newAmount = Math.max(keys - amount, 0);
                if (newAmount < 1) {
                    configuration.set("Players." + String.valueOf(uuid) + "." + fileName, null);
                } else {
                    configuration.set("Players." + String.valueOf(uuid) + "." + fileName, (Object)newAmount);
                }
                if (crate.getCrateType() == CrateType.cosmic) {
                    this.addOpenedCrate(player.getUniqueId(), fileName, amount);
                }
                this.data.save();
                return true;
            }
            case free_key: {
                return true;
            }
        }
        MiscUtils.failedToTakeKey((CommandSender)player, fileName);
        return false;
    }

    @Override
    public boolean hasPhysicalKey(@NotNull UUID uuid, @NotNull String crateName, boolean checkHand) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return false;
        }
        Player player = this.getUser(uuid);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (checkHand) {
            items.add(player.getEquipment().getItemInMainHand());
            items.add(player.getEquipment().getItemInOffHand());
        } else {
            items.addAll(Arrays.asList(player.getInventory().getContents()));
            items.removeAll(Arrays.asList(player.getInventory().getArmorContents()));
        }
        for (ItemStack item : items) {
            if (item == null || !ItemUtils.isSimilar(item, crate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addOfflineKeys(@NotNull UUID uuid, @NotNull String crateName, @NotNull KeyType keyType, int keys) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return false;
        }
        String fileName = crate.getFileName();
        try {
            YamlConfiguration configuration = this.data.getConfiguration();
            if (keyType == KeyType.physical_key) {
                if (configuration.contains("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName)) {
                    keys += configuration.getInt("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName);
                }
                configuration.set("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName, (Object)keys);
                this.data.save();
                return true;
            }
            if (configuration.contains("Offline-Players." + String.valueOf(uuid) + "." + fileName)) {
                keys += configuration.getInt("Offline-Players." + String.valueOf(uuid) + "." + fileName);
            }
            configuration.set("Offline-Players." + String.valueOf(uuid) + "." + fileName, (Object)keys);
            this.data.save();
            return true;
        }
        catch (Exception exception) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("Could not add keys to offline player with uuid: {}", (Object)uuid, (Object)exception);
            }
            return false;
        }
    }

    @Override
    public boolean takeOfflineKeys(@NotNull UUID uuid, @NotNull String crateName, @NotNull KeyType keyType, int keys) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return false;
        }
        String fileName = crate.getFileName();
        try {
            YamlConfiguration configuration = this.data.getConfiguration();
            if (keyType == KeyType.physical_key) {
                int offlineKeys = configuration.getInt("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName);
                if (offlineKeys < keys) {
                    keys = offlineKeys;
                }
                configuration.set("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName, (Object)(configuration.getInt("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName) - keys));
                if (configuration.getInt("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName) <= 0) {
                    configuration.set("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName, null);
                }
                this.data.save();
                return true;
            }
            configuration.set("Offline-Players." + String.valueOf(uuid) + "." + fileName, (Object)(configuration.getInt("Offline-Players." + String.valueOf(uuid) + "." + fileName) - keys));
            this.data.save();
            return true;
        }
        catch (Exception exception) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("Could not take keys from offline player with uuid: {}", (Object)uuid, (Object)exception);
            }
            return false;
        }
    }

    public void loadOldOfflinePlayersKeys(@NotNull Player player, @NotNull List<Crate> crates) {
        String name = player.getName().toLowerCase();
        YamlConfiguration configuration = this.data.getConfiguration();
        if (configuration.contains("Offline-Players." + name)) {
            for (Crate crate : crates) {
                String fileName = crate.getFileName();
                if (!configuration.contains("Offline-Players." + name + "." + fileName)) continue;
                PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.OFFLINE_PLAYER, 1);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                int keys = this.getVirtualKeys(player.getUniqueId(), fileName);
                int addedKeys = configuration.getInt("Offline-Players." + name + "." + fileName);
                configuration.set("Players." + String.valueOf(player.getUniqueId()) + "." + fileName, (Object)Math.max(keys + addedKeys, 0));
                this.data.save();
            }
            configuration.set("Offline-Players." + name, null);
            this.data.save();
        }
    }

    public void loadOfflinePlayersKeys(@NotNull Player player, @NotNull List<Crate> crates) {
        ConfigurationSection section;
        YamlConfiguration configuration = this.data.getConfiguration();
        if (!configuration.contains("Offline-Players." + String.valueOf(player.getUniqueId())) || crates.isEmpty()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        for (Crate crate : crates) {
            int keysGiven;
            int amount;
            PlayerReceiveKeyEvent event;
            String fileName = crate.getFileName();
            if (configuration.contains("Offline-Players." + String.valueOf(uuid) + "." + fileName)) {
                event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.OFFLINE_PLAYER, 1);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                amount = configuration.getInt("Offline-Players." + String.valueOf(uuid) + "." + fileName);
                for (keysGiven = 0; keysGiven < amount; ++keysGiven) {
                    if (crate.getCrateType() != CrateType.crate_on_the_go || !MiscUtils.isInventoryFull(player)) continue;
                    player.getWorld().dropItemNaturally(player.getLocation(), crate.getKey(amount, player));
                    break;
                }
                if (crate.getCrateType() == CrateType.crate_on_the_go) {
                    MiscUtils.addItem(player, crate.getKey(amount, player));
                } else {
                    this.addVirtualKeys(uuid, fileName, amount);
                }
                if (keysGiven >= amount) {
                    configuration.set("Offline-Players." + String.valueOf(uuid) + "." + crate.getFileName(), null);
                }
            }
            if (!configuration.contains("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName)) continue;
            event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.OFFLINE_PLAYER, 1);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount = configuration.getInt("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName);
            for (keysGiven = 0; keysGiven < amount; ++keysGiven) {
                if (!MiscUtils.isInventoryFull(player)) continue;
                player.getWorld().dropItemNaturally(player.getLocation(), crate.getKey(amount - keysGiven, player));
                break;
            }
            MiscUtils.addItem(player, crate.getKey(keysGiven, player));
            if (keysGiven < amount) continue;
            configuration.set("Offline-Players." + String.valueOf(uuid) + ".Physical." + fileName, null);
        }
        ConfigurationSection physicalSection = configuration.getConfigurationSection("Offline-Players." + String.valueOf(uuid) + ".Physical");
        if (physicalSection != null && physicalSection.getKeys(false).isEmpty()) {
            configuration.set("Offline-Players." + String.valueOf(uuid) + ".Physical", null);
        }
        if ((section = configuration.getConfigurationSection("Offline-Players." + String.valueOf(uuid))) != null && section.getKeys(false).isEmpty()) {
            configuration.set("Offline-Players." + String.valueOf(uuid), null);
        }
        this.data.save();
    }

    @Override
    public int getTotalCratesOpened(@NotNull UUID uuid) {
        return this.data.getConfiguration().getInt("Players." + String.valueOf(uuid) + ".tracking.total-crates", 0);
    }

    @Override
    public int getCrateOpened(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return 0;
        }
        return this.data.getConfiguration().getInt("Players." + String.valueOf(uuid) + ".tracking." + crateName, 0);
    }

    @Override
    public void addOpenedCrate(@NotNull UUID uuid, @NotNull String crateName, int amount) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        boolean hasValue = configuration.contains("Players." + String.valueOf(uuid) + ".tracking." + fileName);
        if (hasValue) {
            int newAmount = configuration.getInt("Players." + String.valueOf(uuid) + ".tracking." + fileName) + amount;
            configuration.set("Players." + String.valueOf(uuid) + ".tracking." + fileName, (Object)newAmount);
            configuration.set("Players." + String.valueOf(uuid) + ".tracking.total-crates", (Object)(configuration.getInt("Players." + String.valueOf(uuid) + ".tracking.total-crates") + amount));
            this.data.save();
            return;
        }
        configuration.set("Players." + String.valueOf(uuid) + ".tracking.total-crates", (Object)(configuration.getInt("Players." + String.valueOf(uuid) + ".tracking.total-crates", 0) + amount));
        configuration.set("Players." + String.valueOf(uuid) + ".tracking." + fileName, (Object)amount);
        this.data.save();
    }

    @Override
    public void addOpenedCrate(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        String fileName = crate.getFileName();
        YamlConfiguration configuration = this.data.getConfiguration();
        boolean hasValue = configuration.contains("Players." + String.valueOf(uuid) + ".tracking." + fileName);
        if (hasValue) {
            int amount = configuration.getInt("Players." + String.valueOf(uuid) + ".tracking." + fileName);
            configuration.set("Players." + String.valueOf(uuid) + ".tracking." + fileName, (Object)(amount + 1));
            configuration.set("Players." + String.valueOf(uuid) + ".tracking.total-crates", (Object)(configuration.getInt("Players." + String.valueOf(uuid) + ".tracking.total-crates") + 1));
            this.data.save();
            return;
        }
        int amount = configuration.contains("Players." + String.valueOf(uuid) + ".tracking.total-crates") ? configuration.getInt("Players." + String.valueOf(uuid) + ".tracking.total-crates") + 1 : 1;
        configuration.set("Players." + String.valueOf(uuid) + ".tracking.total-crates", (Object)amount);
        configuration.set("Players." + String.valueOf(uuid) + ".tracking." + fileName, (Object)1);
        this.data.save();
    }

    public int getCrateRespin(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return 0;
        }
        return this.data.getConfiguration().getInt("Players." + String.valueOf(uuid) + ".respins." + crateName + ".amount", 0);
    }

    public void addRespinPrize(@NotNull UUID uuid, @NotNull String crateName, String prize) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        configuration.set("Players." + String.valueOf(uuid) + ".respins." + fileName + ".prize", (Object)prize);
        this.data.save();
    }

    public final boolean hasRespinPrize(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return false;
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        return configuration.contains("Players." + String.valueOf(uuid) + ".respins." + fileName + ".prize");
    }

    public void removeRespinPrize(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        String prize = configuration.getString("Players." + String.valueOf(uuid) + ".respins." + fileName + ".prize");
        if (prize == null) {
            return;
        }
        configuration.set("Players." + String.valueOf(uuid) + ".respins." + fileName + ".prize", null);
        this.data.save();
    }

    public String getRespinPrize(@NotNull UUID uuid, @NotNull String crateName) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return "";
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        return configuration.getString("Players." + String.valueOf(uuid) + ".respins." + fileName + ".prize", "");
    }

    public void removeRespinCrate(@NotNull UUID uuid, @NotNull String crateName, int amount) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        YamlConfiguration configuration = this.data.getConfiguration();
        String fileName = crate.getFileName();
        boolean hasValue = configuration.contains("Players." + String.valueOf(uuid) + ".respins." + fileName);
        if (hasValue) {
            int newAmount = configuration.getInt("Players." + String.valueOf(uuid) + ".respins." + fileName + ".amount") - amount;
            configuration.set("Players." + String.valueOf(uuid) + ".respins." + fileName + ".amount", (Object)(newAmount <= 0 ? null : Integer.valueOf(newAmount)));
            this.data.save();
        }
    }

    public void addRespinCrate(@NotNull UUID uuid, @NotNull String crateName, int amount) {
        Crate crate = this.isCrateInvalid(crateName);
        if (crate == null) {
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().warn("Crate {} doesn't exist.", (Object)crateName);
            }
            return;
        }
        String fileName = crate.getFileName();
        YamlConfiguration configuration = this.data.getConfiguration();
        boolean hasValue = configuration.contains("Players." + String.valueOf(uuid) + ".respins." + fileName);
        if (hasValue) {
            int newAmount = configuration.getInt("Players." + String.valueOf(uuid) + ".respins." + fileName + ".amount") + amount;
            configuration.set("Players." + String.valueOf(uuid) + ".respins." + fileName + ".amount", (Object)newAmount);
            this.data.save();
            return;
        }
        configuration.set("Players." + String.valueOf(uuid) + ".respins." + fileName + ".amount", (Object)amount);
        this.data.save();
    }

    @Nullable
    private Crate isCrateInvalid(@NotNull String crateName) {
        if (crateName.isEmpty()) {
            return null;
        }
        if (this.crateManager.getCrateFromName(crateName) != null) {
            return this.crateManager.getCrateFromName(crateName);
        }
        return null;
    }

    public LegacyItemBuilder addPlaceholders(@NotNull LegacyItemBuilder itemBuilder, @NotNull Crate crate) {
        String fileName = crate.getFileName();
        if (fileName.isEmpty()) {
            return itemBuilder;
        }
        UUID uuid = itemBuilder.getPlayer();
        if (uuid == null) {
            return itemBuilder;
        }
        int virtualKeys = this.getVirtualKeys(uuid, fileName);
        int physicalKeys = this.getPhysicalKeys(uuid, fileName);
        int totalKeys = virtualKeys + physicalKeys;
        int openedCrates = this.getCrateOpened(uuid, fileName);
        NumberFormat instance = NumberFormat.getNumberInstance();
        return (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)itemBuilder.addNamePlaceholder("%keys%", instance.format(virtualKeys))).addNamePlaceholder("%keys_physical%", instance.format(physicalKeys))).addNamePlaceholder("%keys_total%", instance.format(totalKeys))).addNamePlaceholder("%crate_opened%", instance.format(openedCrates))).addNamePlaceholder("%keys_raw%", String.valueOf(virtualKeys))).addNamePlaceholder("%keys_physical_raw%", String.valueOf(physicalKeys))).addNamePlaceholder("%keys_total_raw%", String.valueOf(totalKeys))).addNamePlaceholder("%crate_opened_raw", String.valueOf(openedCrates));
    }
}

