/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CratePrizeMenu;
import java.util.UUID;
import net.kyori.adventure.sound.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class MiscListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final InventoryManager inventoryManager = this.plugin.getInventoryManager();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.crateManager.setNewPlayerKeys(player);
        this.userManager.loadOldOfflinePlayersKeys(player, this.crateManager.getUsableCrates());
        this.userManager.loadOfflinePlayersKeys(player, this.crateManager.getUsableCrates());
        UUID uuid = player.getUniqueId();
        int count = 0;
        for (Crate crate : this.crateManager.getUsableCrates()) {
            String fileName = crate.getFileName();
            if (!crate.isCyclePrize() || !this.userManager.hasRespinPrize(uuid, fileName)) continue;
            if (PrizeManager.isCapped(crate, player)) {
                PrizeManager.givePrize(player, crate, crate.getPrize(this.userManager.getRespinPrize(uuid, fileName)));
                this.userManager.removeRespinPrize(uuid, fileName);
                if (!crate.isCyclePersistRestart()) {
                    this.userManager.removeRespinCrate(uuid, fileName, this.userManager.getCrateRespin(uuid, fileName));
                }
                ++count;
                continue;
            }
            new CrateSpinMenu(player, new GuiSettings(crate, crate.getPrize(this.userManager.getRespinPrize(uuid, fileName)), FileKeys.respin_gui.getConfiguration())).open();
            break;
        }
        if (count > 0) {
            Messages.crate_prize_respins_claimed.sendMessage((CommandSender)player, "{amount}", String.valueOf(count));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAttemptPickUp(PlayerAttemptPickupItemEvent event) {
        if (this.crateManager.isDisplayReward((Entity)event.getItem())) {
            event.setCancelled(true);
            return;
        }
        if (this.crateManager.isInOpeningList(event.getPlayer())) {
            if (this.crateManager.getOpeningCrate(event.getPlayer()).getCrateType().equals((Object)CrateType.quick_crate)) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.inventoryManager.removePreviewViewer(player.getUniqueId());
        this.crateManager.removeTier(player);
        this.crateManager.endQuickCrate(player, player.getLocation(), this.crateManager.getOpeningCrate(player), false);
        this.crateManager.endCrate(player);
        this.crateManager.endQuadCrate(player);
        this.crateManager.removeCloser(player);
        this.crateManager.removeHands(player);
        this.crateManager.removePicker(player);
        this.crateManager.removePlayerKeyType(player);
        this.crateManager.removeSlot(player);
        this.crateManager.removeEditorCrate(player);
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder inventoryHolder = inventory.getHolder(false);
        if (!(inventoryHolder instanceof CratePrizeMenu)) {
            return;
        }
        CratePrizeMenu holder = (CratePrizeMenu)inventoryHolder;
        Player player = holder.getPlayer();
        Crate crate = this.crateManager.getOpeningCrate(player);
        if (!this.crateManager.isInOpeningList(player) || crate == null) {
            return;
        }
        switch (crate.getCrateType()) {
            case war: {
                if (!this.crateManager.hasCrateTask(player)) break;
                this.crateManager.removeCloser(player);
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.endCrate(player);
                break;
            }
            case cosmic: {
                CosmicCrateManager crateManager = (CosmicCrateManager)crate.getManager();
                boolean playSound = false;
                if (holder.contains(" - Prizes")) {
                    for (Integer key : crateManager.getPrizes(player).keySet()) {
                        Tier tier;
                        ItemStack item = inventory.getItem(key.intValue());
                        if (item == null || (tier = this.crateManager.getTier(crate, item)) == null) continue;
                        Prize prize = crate.pickPrize(player, tier);
                        for (int stop = 0; prize == null && stop <= 2000; ++stop) {
                            prize = crate.pickPrize(player, tier);
                        }
                        PrizeManager.givePrize(player, crate, prize);
                        playSound = true;
                    }
                }
                if (playSound) {
                    crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
                }
                this.crateManager.removePlayerFromOpeningList(player);
                this.crateManager.removePlayerKeyType(player);
                this.crateManager.removeTier(player);
                this.crateManager.removeCrateTask(player);
                this.crateManager.removeHands(player);
                this.crateManager.removeSlot(player);
                crateManager.removePickedPlayer(player);
            }
        }
    }

    @EventHandler
    public void onItemPickUp(InventoryPickupItemEvent event) {
        if (this.crateManager.isDisplayReward((Entity)event.getItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDragEvent(InventoryDragEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        if (inventory.getHolder(false) instanceof CratePrizeMenu) {
            event.setCancelled(true);
        }
    }
}

