/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.relations;

import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.commands.MessageManager;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.core.extention.meta.MetaKey;
import dev.triumphteam.cmd.core.message.MessageKey;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public class ArgumentRelations
extends MessageManager {
    private String getContext(String command, String order) {
        if (command.isEmpty() || order.isEmpty()) {
            return "";
        }
        Object usage = null;
        switch (command) {
            case "transfer": {
                usage = order + " <crate_name> <player_name> <amount>";
                break;
            }
            case "claim": 
            case "preview": 
            case "set": {
                usage = order + " <crate_name>";
                break;
            }
            case "editor": {
                usage = order + "-c/--crate <crate> or -e/--exit";
                break;
            }
            case "debug": {
                usage = order + " <crate_name> [player_name]";
                break;
            }
            case "open": {
                usage = order + " <crate_name> <key_type>";
                break;
            }
            case "tp": {
                usage = order + " <id>";
                break;
            }
            case "additem": {
                usage = order + " <crate_name> <prize_number> <chance> [tier]";
                break;
            }
            case "preview-others": 
            case "forceopen": {
                usage = order + " <crate_name> <player_name>";
                break;
            }
            case "open-others": {
                usage = order + " <crate_name> <player_name> [key_type]";
                break;
            }
            case "mass-open": {
                usage = order + " <crate_name> <key_type> <amount>";
                break;
            }
            case "give-random": {
                usage = order + " <key_type> <amount> <player_name> [-s/--silent]";
                break;
            }
            case "take": {
                usage = order + " <key_type> <crate_name> <amount> <player_name>";
                break;
            }
            case "give": {
                usage = order + " <key_type> <crate_name> <amount> <player_name> [-s/--silent]";
                break;
            }
            case "giveall": {
                usage = order + " <key_type> <crate_name> <amount> [-s/--silent]";
                break;
            }
            case "migrate": {
                usage = order + " -mt <migration_type> [-c/--crate] <crate> [-d/--data]";
                break;
            }
            case "respin-accept": {
                usage = order + " <player> <crate_name> [prize_name]";
                break;
            }
            case "respin-deny": {
                usage = order + " <player> <crate_name>";
                break;
            }
            case "respin-remove": 
            case "respin-add": {
                usage = order + " <player> <crate_name> <amount>";
                break;
            }
            case "admin": {
                usage = order;
            }
        }
        return usage;
    }

    @Override
    public void build() {
        this.commandManager.registerMessage(BukkitMessageKey.UNKNOWN_COMMAND, (sender, context) -> Messages.unknown_command.sendMessage((CommandSender)sender, "{command}", context.getInvalidInput()));
        this.commandManager.registerMessage(MessageKey.TOO_MANY_ARGUMENTS, (sender, context) -> {
            Optional<String> meta = context.getMeta().get(MetaKey.NAME);
            meta.ifPresent(key -> {
                if (key.equalsIgnoreCase("view")) {
                    Messages.correct_usage.sendMessage((CommandSender)sender, "{usage}", this.getContext((String)key, "/keys " + key));
                    return;
                }
                Messages.correct_usage.sendMessage((CommandSender)sender, "{usage}", this.getContext((String)key, "/crazycrates " + key));
            });
        });
        this.commandManager.registerMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> {
            Optional<String> meta = context.getMeta().get(MetaKey.NAME);
            meta.ifPresent(key -> {
                if (key.equalsIgnoreCase("view")) {
                    Messages.correct_usage.sendMessage((CommandSender)sender, "{usage}", this.getContext((String)key, "/keys " + key));
                    return;
                }
                Messages.correct_usage.sendMessage((CommandSender)sender, "{usage}", this.getContext((String)key, "/crazycrates " + key));
            });
        });
        this.commandManager.registerMessage(MessageKey.INVALID_ARGUMENT, (sender, context) -> Messages.correct_usage.sendMessage((CommandSender)sender, "{usage}", context.getSyntax()));
        this.commandManager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> Messages.no_permission.sendMessage((CommandSender)sender, "{permission}", context.getPermission().toString()));
        this.commandManager.registerMessage(BukkitMessageKey.PLAYER_ONLY, (sender, context) -> Messages.must_be_a_player.sendMessage((CommandSender)sender));
        this.commandManager.registerMessage(BukkitMessageKey.CONSOLE_ONLY, (sender, context) -> Messages.must_be_console_sender.sendMessage((CommandSender)sender));
    }
}

