/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.keys;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import com.badbones69.crazycrates.paper.managers.events.EventManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CommandOpen
extends BaseCommand {
    private boolean isCancelled(Player player, String crateName) {
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return true;
        }
        if (this.crateManager.isInOpeningList(player)) {
            Messages.already_opening_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return true;
        }
        if (MiscUtils.isInventoryFull(player)) {
            Messages.inventory_not_empty.sendMessage((CommandSender)player, "{crate}", crateName);
            return true;
        }
        return false;
    }

    @Command(value="open")
    @Permission(value={"crazycrates.open"}, def=PermissionDefault.OP)
    public void open(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="key_type") @Suggestion(value="keys") String type) {
        boolean hasKey;
        if (this.isCancelled(player, crateName)) {
            return;
        }
        Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        CrateType crateType = crate.getCrateType();
        if (crateType == null || crate.getCrateType() == CrateType.menu) {
            Messages.internal_error.sendMessage((CommandSender)player);
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("An error has occurred: The crate type is null or Menu for the crate named {}", (Object)crateName);
            }
            return;
        }
        String fancyName = crate.getCrateName();
        String fileName = crate.getFileName();
        if (crateType == CrateType.crate_on_the_go || crateType == CrateType.quick_crate || crateType == CrateType.fire_cracker || crateType == CrateType.quad_crate) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{cratetype}", crateType.getName());
            placeholders.put("{crate}", fancyName);
            Messages.cant_be_a_virtual_crate.sendMessage((CommandSender)player, placeholders);
            return;
        }
        KeyType keyType = this.getKeyType(type);
        boolean bl = this.config.getProperty(ConfigKeys.virtual_accepts_physical_keys).booleanValue() && keyType == KeyType.physical_key ? this.userManager.getTotalKeys(player.getUniqueId(), fileName) >= 1 : (hasKey = this.userManager.getVirtualKeys(player.getUniqueId(), fileName) >= 1);
        if (!hasKey) {
            if (this.config.getProperty(ConfigKeys.need_key_sound_toggle).booleanValue()) {
                Sound sound = Sound.sound((Key)Key.key((String)this.config.getProperty(ConfigKeys.need_key_sound)), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
                player.playSound(sound);
            }
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{crate}", fancyName);
            placeholders.put("{key}", crate.getKeyName());
            Messages.no_keys.sendMessage((CommandSender)player, placeholders);
            return;
        }
        this.crateManager.openCrate(player, crate, keyType, player.getLocation(), true, false, EventType.event_crate_opened);
    }

    @Command(value="open-others")
    @Permission(value={"crazycrates.open-others"}, def=PermissionDefault.OP)
    public void others(CommandSender sender, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="player") @Suggestion(value="players") Player player, @ArgName(value="key_type") @Suggestion(value="keys") String type) {
        boolean hasKey;
        if (this.isCancelled(player, crateName)) {
            return;
        }
        final Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        CrateType crateType = crate.getCrateType();
        if (crateType == null) {
            Messages.internal_error.sendMessage(sender);
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("An error has occurred: The crate type is null for the crate named {}", (Object)crateName);
            }
            return;
        }
        final String fancyName = crate.getCrateName();
        String fileName = crate.getFileName();
        if (crateType == CrateType.crate_on_the_go || crateType == CrateType.quick_crate || crateType == CrateType.fire_cracker || crateType == CrateType.quad_crate) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{cratetype}", crateType.getName());
            placeholders.put("{crate}", fancyName);
            Messages.cant_be_a_virtual_crate.sendMessage(sender, placeholders);
            return;
        }
        KeyType keyType = this.getKeyType(type);
        if (sender == player) {
            this.open(player, crateName, type);
            return;
        }
        boolean bl = this.config.getProperty(ConfigKeys.virtual_accepts_physical_keys).booleanValue() && keyType == KeyType.physical_key ? this.userManager.getTotalKeys(player.getUniqueId(), fileName) >= 1 : (hasKey = this.userManager.getVirtualKeys(player.getUniqueId(), fileName) >= 1);
        if (!hasKey) {
            if (this.config.getProperty(ConfigKeys.need_key_sound_toggle).booleanValue()) {
                Sound sound = Sound.sound((Key)Key.key((String)this.config.getProperty(ConfigKeys.need_key_sound)), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
                player.playSound(sound);
            }
            Messages.no_keys.sendMessage(sender, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{crate}", fancyName);
                    this.put("{key}", crate.getKeyName());
                }
            });
            return;
        }
        this.crateManager.openCrate(player, crate, keyType, player.getLocation(), true, false, EventType.event_crate_opened);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{crate}", fancyName);
        placeholders.put("{player}", player.getName());
        Messages.opened_a_crate.sendMessage(sender, placeholders);
    }

    @Command(value="forceopen")
    @Permission(value={"crazycrates.forceopen"}, def=PermissionDefault.OP)
    public void forceopen(CommandSender sender, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="player") @Suggestion(value="players") Player player) {
        if (this.isCancelled(player, crateName)) {
            return;
        }
        Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        CrateType crateType = crate.getCrateType();
        if (crateType == null) {
            Messages.internal_error.sendMessage(sender);
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("An error has occurred: The crate type is null for the crate named {}", (Object)crateName);
            }
            return;
        }
        String fancyName = crate.getCrateName();
        if (crateType == CrateType.crate_on_the_go || crateType == CrateType.quick_crate || crateType == CrateType.fire_cracker || crateType == CrateType.quad_crate) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("{cratetype}", crateType.getName());
            placeholders.put("{crate}", fancyName);
            Messages.cant_be_a_virtual_crate.sendMessage(sender, placeholders);
            return;
        }
        this.crateManager.openCrate(player, crate, KeyType.free_key, player.getLocation(), true, false, EventType.event_crate_force_opened);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{crate}", fancyName);
        placeholders.put("{player}", player.getName());
        Messages.opened_a_crate.sendMessage(sender, placeholders);
    }

    @Command(value="mass-open")
    @Permission(value={"crazycrates.massopen"}, def=PermissionDefault.OP)
    public void mass(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="key_type") @Suggestion(value="keys") String type, @ArgName(value="amount") @Suggestion(value="numbers") int amount) {
        int used;
        if (this.isCancelled(player, crateName)) {
            return;
        }
        Crate crate = this.getCrate((CommandSender)player, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        CrateType crateType = crate.getCrateType();
        if (crateType == null) {
            Messages.internal_error.sendMessage((CommandSender)player);
            if (MiscUtils.isLogging()) {
                this.plugin.getComponentLogger().error("An error has occurred: The crate type is null for the crate named {}", (Object)crate.getFileName());
            }
            return;
        }
        final String fancyName = crate.getCrateName();
        String fileName = crate.getFileName();
        final String keyName = crate.getKeyName();
        KeyType keyType = this.getKeyType(type);
        int keys = keyType == KeyType.physical_key ? this.userManager.getPhysicalKeys(player.getUniqueId(), fileName) : this.userManager.getVirtualKeys(player.getUniqueId(), fileName);
        if (keys == 0) {
            Messages.no_keys.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{crate}", fancyName);
                    this.put("{key}", keyName);
                }
            });
            return;
        }
        final int requiredKeys = crate.getRequiredKeys();
        if (crate.useRequiredKeys() && keys < requiredKeys) {
            final int finalKeys = keys;
            Messages.not_enough_keys.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{required_amount}", String.valueOf(requiredKeys));
                    this.put("{key_amount}", String.valueOf(requiredKeys));
                    this.put("{amount}", String.valueOf(finalKeys));
                    this.put("{crate}", fancyName);
                    this.put("{key}", keyName);
                }
            });
            return;
        }
        this.crateManager.addPlayerToOpeningList(player, crate);
        block5: for (used = 0; keys > 0 && !MiscUtils.isInventoryFull(player) && used < amount && used < crate.getMaxMassOpen(); ++used, --keys) {
            switch (crateType) {
                case casino: {
                    ConfigurationSection section = crate.getFile().getConfigurationSection("Crate.random");
                    if (section == null) continue block5;
                    boolean isRandom = section.getBoolean("toggle", false);
                    if (isRandom) {
                        List<Tier> tiers = crate.getTiers();
                        int size = tiers.size();
                        ThreadLocalRandom random = ThreadLocalRandom.current();
                        Tier tier = tiers.get(random.nextInt(size));
                        PrizeManager.givePrize(player, crate, crate.pickPrize(player, tier));
                        PrizeManager.givePrize(player, crate, crate.pickPrize(player, tier));
                        PrizeManager.givePrize(player, crate, crate.pickPrize(player, tier));
                        continue block5;
                    }
                    @Nullable Tier row_uno = crate.getTier(section.getString("types.row-1", ""));
                    @Nullable Tier row_dos = crate.getTier(section.getString("types.row-2", ""));
                    @Nullable Tier row_tres = crate.getTier(section.getString("types.row-3", ""));
                    if (row_uno == null || row_dos == null || row_tres == null) {
                        Logger logger = this.plugin.getLogger();
                        if (MiscUtils.isLogging()) {
                            List.of("One of your rows has a tier that doesn't exist supplied in " + fileName, "You can find this in your crate config, search for row-1, row-2, and row-3").forEach(logger::warning);
                        }
                        --used;
                        continue block5;
                    }
                    PrizeManager.givePrize(player, crate, crate.pickPrize(player, row_uno));
                    PrizeManager.givePrize(player, crate, crate.pickPrize(player, row_dos));
                    PrizeManager.givePrize(player, crate, crate.pickPrize(player, row_tres));
                    continue block5;
                }
                case cosmic: {
                    List<Tier> tiers = crate.getTiers();
                    if (tiers.isEmpty()) {
                        --used;
                        continue block5;
                    }
                    int size = tiers.size();
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    CosmicCrateManager cosmicCrateManager = (CosmicCrateManager)crate.getManager();
                    int totalPrizes = cosmicCrateManager.getTotalPrizes();
                    for (int i = 0; i < totalPrizes; ++i) {
                        Tier tier = tiers.get(random.nextInt(size));
                        Prize prize = crate.pickPrize(player, tier);
                        PrizeManager.givePrize(player, crate, prize);
                    }
                    continue block5;
                }
                case quad_crate: {
                    for (int i = 0; i < 4; ++i) {
                        PrizeManager.givePrize(player, crate, crate.pickPrize(player));
                    }
                    continue block5;
                }
                default: {
                    Prize prize = crate.pickPrize(player);
                    PrizeManager.givePrize(player, crate, prize);
                }
            }
        }
        this.userManager.addOpenedCrate(player.getUniqueId(), fileName, used);
        EventManager.logEvent(EventType.event_crate_opened, player.getName(), (CommandSender)player, crate, keyType, used);
        EventManager.logEvent(EventType.event_key_taken, player.getName(), (CommandSender)player, crate, keyType, used);
        if (!this.userManager.takeKeys(player.getUniqueId(), fileName, keyType, used, false)) {
            this.crateManager.removeCrateInUse(player);
            this.crateManager.removePlayerFromOpeningList(player);
            return;
        }
        this.crateManager.removePlayerFromOpeningList(player);
    }
}

