/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class WeightMigrator
extends ICrateMigrator {
    public WeightMigrator(CommandSender sender) {
        super(sender, MigrationType.WEIGHT_MIGRATION);
    }

    @Override
    public void run() {
        Collection<LegacyCustomFile> customFiles = this.plugin.getFileManager().getFiles().values();
        final ArrayList failed = new ArrayList();
        final ArrayList success = new ArrayList();
        customFiles.forEach(customFile -> {
            try {
                ConfigurationSection prizes;
                ConfigurationSection tiers;
                if (!customFile.isDynamic()) {
                    return;
                }
                YamlConfiguration configuration = customFile.getConfiguration();
                if (configuration == null) {
                    return;
                }
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                if (section.contains("Tiers") && (tiers = section.getConfigurationSection("Tiers")) != null) {
                    tiers.getKeys(false).forEach(key -> {
                        ConfigurationSection tier = tiers.getConfigurationSection(key);
                        if (tier != null) {
                            int chance = tier.getInt("Chance");
                            int maxRange = tier.getInt("MaxRange");
                            if (maxRange > 100000) {
                                maxRange = 100000;
                            }
                            tier.set("Weight", (Object)MiscUtils.calculateWeight(chance, maxRange));
                        }
                    });
                    isSave = true;
                }
                if ((prizes = section.getConfigurationSection("Prizes")) != null) {
                    for (String value : prizes.getKeys(false)) {
                        ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null) continue;
                        int chance = 10;
                        int maxRange = 100;
                        if (prizeSection.contains("Chance")) {
                            chance = prizeSection.getInt("Chance", 10);
                            isSave = true;
                        }
                        if (prizeSection.contains("MaxRange")) {
                            maxRange = prizeSection.getInt("MaxRange", 100);
                            isSave = true;
                        }
                        if (maxRange > 100000) {
                            maxRange = 100000;
                        }
                        prizeSection.set("Weight", (Object)MiscUtils.calculateWeight(chance, maxRange));
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getEffectiveName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + customFile.getEffectiveName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
        this.fileManager.init();
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

