/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.core.enums.Comments;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import libs.com.ryderbelserion.fusion.api.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.potion.PotionEffectType;

public class NewItemMigrator
extends ICrateMigrator {
    public NewItemMigrator(CommandSender sender) {
        super(sender, MigrationType.NEW_ITEM_FORMAT);
    }

    @Override
    public void run() {
        Collection<LegacyCustomFile> customFiles = this.plugin.getFileManager().getFiles().values();
        final ArrayList failed = new ArrayList();
        final ArrayList success = new ArrayList();
        customFiles.forEach(customFile -> {
            try {
                if (!customFile.isDynamic()) {
                    return;
                }
                YamlConfiguration configuration = customFile.getConfiguration();
                if (configuration == null) {
                    return;
                }
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                ConfigurationSection prizes = section.getConfigurationSection("Prizes");
                if (prizes != null) {
                    for (String value : prizes.getKeys(false)) {
                        final ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null || !prizeSection.isList("Items")) continue;
                        ArrayList<String> items = new ArrayList<String>(){
                            {
                                this.addAll(prizeSection.getStringList("Items"));
                            }
                        };
                        prizeSection.set("Items", null);
                        items.forEach(item -> {
                            HashMap<String, String> patterns = new HashMap<String, String>();
                            HashMap<String, Integer> enchantments = new HashMap<String, Integer>();
                            String uuid = MiscUtils.randomUUID();
                            block42: for (String key : item.split(", ")) {
                                String option = key.split(":")[0];
                                String type = key.replace(option + ":", "").replace(option, "");
                                switch (option.toLowerCase()) {
                                    case "item": {
                                        prizeSection.set("Items." + uuid + ".material", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".Material", Comments.material.getComments());
                                        continue block42;
                                    }
                                    case "data": {
                                        prizeSection.set("Items." + uuid + ".data", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".data", Comments.base64.getComments());
                                        continue block42;
                                    }
                                    case "name": {
                                        prizeSection.set("Items." + uuid + ".name", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".name", Comments.name.getComments());
                                        continue block42;
                                    }
                                    case "mob": {
                                        prizeSection.set("Items." + uuid + ".settings.mob.type", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.mob.type", Comments.mob_type.getComments());
                                        continue block42;
                                    }
                                    case "glowing": {
                                        prizeSection.set("Items." + uuid + ".settings.glowing", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.glowing", Comments.glowing.getComments());
                                        continue block42;
                                    }
                                    case "amount": {
                                        prizeSection.set("Items." + uuid + ".amount", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".amount", Comments.amount.getComments());
                                        continue block42;
                                    }
                                    case "damage": {
                                        prizeSection.set("Items." + uuid + ".settings.damage", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.damage", Comments.damage.getComments());
                                        continue block42;
                                    }
                                    case "lore": {
                                        prizeSection.set("Items." + uuid + ".lore", List.of(type.split(",")));
                                        prizeSection.setComments("Items." + uuid + ".lore", Comments.lore.getComments());
                                        continue block42;
                                    }
                                    case "player": {
                                        prizeSection.set("Items." + uuid + ".settings.player", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.player", Comments.player.getComments());
                                        continue block42;
                                    }
                                    case "skull": {
                                        prizeSection.set("Items." + uuid + ".settings.skull", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.skull", Comments.skull.getComments());
                                        continue block42;
                                    }
                                    case "custom-model-data": {
                                        prizeSection.set("Items." + uuid + ".custom-model-data", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".custom-model-data", Comments.custom_model_data.getComments());
                                        continue block42;
                                    }
                                    case "unbreakable-item": {
                                        prizeSection.set("Items." + uuid + ".unbreakable-item", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".unbreakable-item", Comments.unbreakable.getComments());
                                        continue block42;
                                    }
                                    case "hide-tool-tip": {
                                        prizeSection.set("Items." + uuid + ".hide-tool-tip", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".hide-tool-tip", Comments.hide_tool_tip.getComments());
                                        continue block42;
                                    }
                                    case "trim-pattern": {
                                        prizeSection.set("Items." + uuid + ".settings.trim.pattern", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".trim.pattern", Comments.trim_pattern.getComments());
                                        continue block42;
                                    }
                                    case "trim-material": {
                                        prizeSection.set("Items." + uuid + ".settings.trim.material", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.trim.material", Comments.trim_material.getComments());
                                        continue block42;
                                    }
                                    case "rgb": {
                                        prizeSection.set("Items." + uuid + ".settings.rgb", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.rgb", Comments.rgb.getComments());
                                        continue block42;
                                    }
                                    case "color": {
                                        prizeSection.set("Items." + uuid + ".settings.color", (Object)type);
                                        prizeSection.setComments("Items." + uuid + ".settings.color", Comments.color.getComments());
                                        continue block42;
                                    }
                                    default: {
                                        String placeholder = option.toLowerCase();
                                        try {
                                            PotionEffectType effect = ItemUtils.getPotionEffect(placeholder);
                                            if (effect != null) {
                                                ConfigurationSection potionsSection = prizeSection.createSection("Items." + uuid + ".settings.potions");
                                                ConfigurationSection potionSection = potionsSection.createSection(placeholder);
                                                potionSection.set("duration", (Object)60);
                                                potionSection.set("level", (Object)1);
                                                potionSection.set("style.icon", (Object)true);
                                                potionSection.set("style.ambient", (Object)true);
                                                potionSection.set("style.particles", (Object)true);
                                                prizeSection.set("Items." + uuid + ".settings.potions", Comments.potions.getComments());
                                            }
                                        }
                                        catch (Exception effect) {
                                            // empty catch block
                                        }
                                        if (ItemUtils.getEnchantment(placeholder) != null) {
                                            enchantments.put(option.toLowerCase(), StringUtils.tryParseInt(value).map(Number::intValue).orElse(1));
                                            ConfigurationSection enchantmentSection = prizeSection.createSection("Items." + uuid + ".enchantments");
                                            prizeSection.setComments("Items." + uuid + ".enchantments", Comments.enchantments.getComments());
                                            enchantments.forEach((arg_0, arg_1) -> ((ConfigurationSection)enchantmentSection).set(arg_0, arg_1));
                                            continue block42;
                                        }
                                        if (!prizeSection.contains("Items." + uuid + ".hide-tool-tip")) {
                                            for (ConfigurationSection itemFlag : ItemFlag.values()) {
                                                if (!itemFlag.name().equalsIgnoreCase(option)) continue;
                                                prizeSection.set("Items." + uuid + ".hide-tool-tip", (Object)true);
                                                prizeSection.setComments("Items." + uuid + ".hide-tool-tip", Comments.hide_tool_tip.getComments());
                                                break;
                                            }
                                        }
                                        try {
                                            PatternType patternType = ItemUtils.getPatternType(placeholder);
                                            if (patternType == null) continue block42;
                                            patterns.put(placeholder, type);
                                            ConfigurationSection patternsSection = prizeSection.createSection("Items." + uuid + ".settings.patterns");
                                            prizeSection.setComments("Items." + uuid + ".settings.patterns", Comments.patterns.getComments());
                                            patterns.forEach((arg_0, arg_1) -> ((ConfigurationSection)patternsSection).set(arg_0, arg_1));
                                            continue block42;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        });
                        isSave = true;
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getEffectiveName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + customFile.getEffectiveName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
        this.fileManager.init();
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

