/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyColorMigrator
extends ICrateMigrator {
    public LegacyColorMigrator(CommandSender sender) {
        super(sender, MigrationType.LEGACY_COLOR_ALL);
    }

    @Override
    public void run() {
        final ArrayList<String> failed = new ArrayList<String>();
        final ArrayList<String> success = new ArrayList<String>();
        try {
            this.config.setProperty(ConfigKeys.command_prefix, AdvUtils.convert(this.config.getProperty(ConfigKeys.command_prefix), true));
            this.config.setProperty(ConfigKeys.inventory_name, AdvUtils.convert(this.config.getProperty(ConfigKeys.inventory_name), true));
            this.config.setProperty(ConfigKeys.menu_button_name, AdvUtils.convert(this.config.getProperty(ConfigKeys.menu_button_name), true));
            this.config.setProperty(ConfigKeys.menu_button_lore, AdvUtils.convert(this.config.getProperty(ConfigKeys.menu_button_lore), true));
            this.config.setProperty(ConfigKeys.next_button_name, AdvUtils.convert(this.config.getProperty(ConfigKeys.next_button_name), true));
            this.config.setProperty(ConfigKeys.next_button_lore, AdvUtils.convert(this.config.getProperty(ConfigKeys.next_button_lore), true));
            this.config.setProperty(ConfigKeys.back_button_name, AdvUtils.convert(this.config.getProperty(ConfigKeys.back_button_name), true));
            this.config.setProperty(ConfigKeys.back_button_lore, AdvUtils.convert(this.config.getProperty(ConfigKeys.back_button_lore), true));
            this.config.setProperty(ConfigKeys.filler_name, AdvUtils.convert(this.config.getProperty(ConfigKeys.filler_name), true));
            this.config.setProperty(ConfigKeys.filler_lore, AdvUtils.convert(this.config.getProperty(ConfigKeys.filler_lore), true));
            success.add("<green>\u2937 config.yml");
            this.config.save();
            this.config.reload();
        }
        catch (Exception exception) {
            failed.add("<red>\u2937 config.yml");
        }
        try {
            for (Messages message : Messages.values()) {
                message.migrate();
            }
            success.add("<green>\u2937 messages.yml");
            this.messages.save();
            this.messages.reload();
        }
        catch (Exception exception) {
            failed.add("<red>\u2937 messages.yml");
        }
        Collection<LegacyCustomFile> customFiles = this.plugin.getFileManager().getFiles().values();
        customFiles.forEach(customFile -> {
            try {
                ConfigurationSection prizes;
                ConfigurationSection tiers;
                if (!customFile.isDynamic()) {
                    return;
                }
                YamlConfiguration configuration = customFile.getConfiguration();
                if (configuration == null) {
                    return;
                }
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                if (section.contains("CrateName")) {
                    this.set(section, "Name", AdvUtils.convert(section.getString("CrateName", " "), true));
                    this.set(section, "CrateName", null);
                    isSave = true;
                } else if (section.contains("Name")) {
                    this.set(section, "Name", AdvUtils.convert(section.getString("Name", " "), true));
                    isSave = true;
                }
                if (section.contains("Preview-Name")) {
                    this.set(section, "Preview.Name", AdvUtils.convert(section.getString("Preview.Name", " "), true));
                    this.set(section, "Preview-Name", null);
                    isSave = true;
                } else if (section.contains("Preview.Name")) {
                    this.set(section, "Preview.Name", AdvUtils.convert(section.getString("Preview.Name", " "), true));
                    isSave = true;
                }
                if (section.contains("Preview.Glass.Name")) {
                    this.set(section, "Preview.Glass.Name", AdvUtils.convert(section.getString("Preview.Glass.Name", " "), true));
                    isSave = true;
                }
                if (section.contains("tier-preview.glass.name")) {
                    this.set(section, "tier-preview.glass.name", AdvUtils.convert(section.getString("tier-preview.glass.name", " "), true));
                    isSave = true;
                }
                if (section.contains("BroadCast")) {
                    this.set(section, "BroadCast", AdvUtils.convert(section.getString("BroadCast", " "), true));
                    isSave = true;
                }
                if (section.contains("Lore")) {
                    this.set(section, "Lore", AdvUtils.convert(section.getStringList("Lore"), true));
                    isSave = true;
                }
                if (section.contains("PhysicalKey")) {
                    this.set(section, "PhysicalKey.Name", AdvUtils.convert(section.getString("PhysicalKey.Name", " "), true));
                    this.set(section, "PhysicalKey.Lore", AdvUtils.convert(section.getStringList("PhysicalKey.Lore"), true));
                    isSave = true;
                }
                if ((tiers = section.getConfigurationSection("Tiers")) != null) {
                    for (String value : tiers.getKeys(false)) {
                        ConfigurationSection tierSection = tiers.getConfigurationSection(value);
                        if (tierSection == null) continue;
                        if (tierSection.contains("Name")) {
                            this.set(tierSection, "Name", AdvUtils.convert(tierSection.getString("Name", " "), true));
                            isSave = true;
                        }
                        if (!tierSection.contains("Lore")) continue;
                        this.set(tierSection, "Lore", AdvUtils.convert(tierSection.getStringList("Name"), true));
                        isSave = true;
                    }
                }
                if ((prizes = section.getConfigurationSection("Prizes")) != null) {
                    for (String value : prizes.getKeys(false)) {
                        ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null) continue;
                        if (prizeSection.contains("Lore")) {
                            this.set(prizeSection, "DisplayLore", AdvUtils.convert(prizeSection.getStringList("Lore"), true));
                            this.set(prizeSection, "Lore", null);
                            isSave = true;
                        } else if (prizeSection.contains("DisplayLore")) {
                            this.set(prizeSection, "DisplayLore", AdvUtils.convert(prizeSection.getStringList("DisplayLore"), true));
                            isSave = true;
                        }
                        if (prizeSection.contains("DisplayName")) {
                            this.set(prizeSection, "DisplayName", AdvUtils.convert(prizeSection.getString("DisplayName", " "), true));
                            isSave = true;
                        }
                        if (prizeSection.contains("Messages")) {
                            this.set(prizeSection, "Messages", AdvUtils.convert(prizeSection.getStringList("Messages"), true));
                            isSave = true;
                        }
                        if (prizeSection.contains("Items")) {
                            this.set(prizeSection, "Items", AdvUtils.convert(prizeSection.getStringList("Items"), true));
                            isSave = true;
                        }
                        if (prizeSection.contains("Alternative-Prize.Messages")) {
                            this.set(prizeSection, "Alternative-Prize.Messages", AdvUtils.convert(prizeSection.getStringList("Alternative-Prize.Messages"), true));
                            isSave = true;
                        }
                        if (!prizeSection.contains("Alternative-Prize.Items")) continue;
                        this.set(prizeSection, "Alternative-Prize.Items", AdvUtils.convert(prizeSection.getStringList("Alternative-Prize.Items"), true));
                        isSave = true;
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getEffectiveName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + customFile.getEffectiveName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
        this.fileManager.init();
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }
}

