/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class DeprecatedCrateMigrator
extends ICrateMigrator {
    public DeprecatedCrateMigrator(CommandSender sender) {
        super(sender, MigrationType.CRATES_DEPRECATED_ALL);
    }

    @Override
    public void run() {
        Collection<LegacyCustomFile> customFiles = this.plugin.getFileManager().getFiles().values();
        final ArrayList failed = new ArrayList();
        final ArrayList success = new ArrayList();
        customFiles.forEach(customFile -> {
            try {
                ConfigurationSection prizes;
                if (!customFile.isDynamic()) {
                    return;
                }
                YamlConfiguration configuration = customFile.getConfiguration();
                if (configuration == null) {
                    return;
                }
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                if (section.contains("CrateName")) {
                    this.set(section, "Name", section.getString("CrateName", " "));
                    this.set(section, "CrateName", null);
                    isSave = true;
                }
                if (section.contains("Preview-Name")) {
                    this.set(section, "Preview.Name", section.getString("Preview-Name", " "));
                    this.set(section, "Preview-Name", null);
                    isSave = true;
                }
                if ((prizes = section.getConfigurationSection("Prizes")) != null) {
                    for (String value : prizes.getKeys(false)) {
                        ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null) continue;
                        if (prizeSection.contains("Lore")) {
                            this.set(prizeSection, "DisplayLore", prizeSection.getStringList("Lore"));
                            this.set(prizeSection, "Lore", null);
                            isSave = true;
                        }
                        if (!prizeSection.contains("Patterns")) continue;
                        this.set(prizeSection, "DisplayPatterns", prizeSection.getStringList("Patterns"));
                        this.set(prizeSection, "Patterns", null);
                        isSave = true;
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getEffectiveName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + customFile.getEffectiveName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
        this.fileManager.init();
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

