/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.editor;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandSet
extends BaseCommand {
    @Command(value="set")
    @Permission(value={"crazycrates.set"}, def=PermissionDefault.OP)
    public void set(Player player, @ArgName(value="crate") @Suggestion(value="crates") String crateName) {
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        Crate crate = this.crateManager.getCrateFromName(crateName);
        if (crate == null) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        if (crate.getCrateType() == CrateType.menu && !this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
            Messages.cannot_set_type.sendMessage((CommandSender)player);
            return;
        }
        Block block = player.getTargetBlock(null, 5);
        if (block.isEmpty()) {
            Messages.must_be_looking_at_block.sendMessage((CommandSender)player);
            return;
        }
        final Location location = block.getLocation();
        if (this.crateManager.isCrateLocation(location)) {
            Messages.physical_crate_already_exists.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    CrateLocation crateLocation = CommandSet.this.crateManager.getCrateLocation(location);
                    this.put("{id}", crateLocation != null ? crateLocation.getID() : "N/A");
                    this.put("{crate}", crateLocation != null ? crateLocation.getCrate().getCrateName() : "N/A");
                }
            });
            return;
        }
        this.crateManager.addCrateLocation(location, crate);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{crate}", crate.getCrateName());
        Messages.created_physical_crate.sendRichMessage((CommandSender)player, placeholders);
    }
}

