/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.editor;

import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.CommandFlags;
import dev.triumphteam.cmd.core.annotations.Flag;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandEditor
extends BaseCommand {
    @Command(value="editor")
    @CommandFlags(value={@Flag(flag="c", longFlag="crate", argument=String.class, suggestion="crates"), @Flag(flag="e", longFlag="exit")})
    @Permission(value={"crazycrates.editor"}, def=PermissionDefault.OP)
    public void editor(Player player, Flags flags) {
        if (flags.hasFlag("e")) {
            this.crateManager.removeEditorCrate(player);
            Messages.editor_exit.sendMessage((CommandSender)player, "{reason}", "you asked.");
            return;
        }
        if (!flags.hasFlag("c")) {
            Messages.lacking_flag.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{flag}", "-c");
                    this.put("{usage}", "/crazycrates editor -c <crate_name>");
                }
            });
            return;
        }
        String crateName = flags.getFlagValue("c").orElse("");
        if (crateName.isEmpty()) {
            Messages.cannot_be_empty.sendMessage((CommandSender)player, "{value}", "crate name");
            return;
        }
        if (this.crateManager.hasEditorCrate(player)) {
            Messages.editor_already_in.sendMessage((CommandSender)player);
            return;
        }
        Crate crate = this.crateManager.getCrateFromName(crateName);
        if (crate == null) {
            Messages.not_a_crate.sendMessage((CommandSender)player, "{crate}", crateName);
            return;
        }
        if (crate.getCrateType() == CrateType.menu && !this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
            Messages.cannot_set_type.sendMessage((CommandSender)player);
            return;
        }
        this.crateManager.addEditorCrate(player, crate);
        Messages.editor_enter.sendMessage((CommandSender)player, "{crate}", crateName);
    }
}

