/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PlayerBuilder;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.CommandAdmin;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.CommandReload;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandAddItem;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandClaim;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandDebug;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandList;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandMigrate;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandPreview;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.CommandTeleport;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.editor.CommandEditor;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.editor.CommandSet;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.keys.CommandGive;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.keys.CommandOpen;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.keys.CommandTake;
import com.badbones69.crazycrates.paper.commands.crates.types.player.CommandHelp;
import com.badbones69.crazycrates.paper.commands.crates.types.player.CommandKey;
import com.badbones69.crazycrates.paper.commands.crates.types.player.CommandTransfer;
import com.badbones69.crazycrates.paper.commands.relations.ArgumentRelations;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import dev.triumphteam.cmd.bukkit.BukkitCommandManager;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final CrateManager crateManager = plugin.getCrateManager();
    private static final BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)plugin);

    public static void load() {
        new ArgumentRelations().build();
        commandManager.registerSuggestion(SuggestionKey.of("crates"), (sender, context) -> {
            ArrayList<String> crates = new ArrayList<String>(crateManager.getCrateNames());
            crates.add("Menu");
            return crates;
        });
        commandManager.registerSuggestion(SuggestionKey.of("keys"), (sender, context) -> List.of("virtual", "v", "physical", "p"));
        commandManager.registerSuggestion(SuggestionKey.of("admin-keys"), (sender, context) -> List.of("virtual", "v", "physical", "p", "free", "f"));
        commandManager.registerSuggestion(SuggestionKey.of("players"), (sender, context) -> plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList());
        commandManager.registerSuggestion(SuggestionKey.of("locations"), (sender, context) -> crateManager.getCrateLocations().stream().map(CrateLocation::getID).toList());
        commandManager.registerSuggestion(SuggestionKey.of("prizes"), (sender, context) -> {
            ArrayList prizes = new ArrayList();
            Crate crate = crateManager.getCrateFromName((String)context.getFirst());
            if (crate != null) {
                crate.getPrizes().forEach(prize -> prizes.add(prize.getSectionName()));
            }
            return prizes;
        });
        commandManager.registerSuggestion(SuggestionKey.of("tiers"), (sender, context) -> {
            ArrayList tiers = new ArrayList();
            Crate crate = crateManager.getCrateFromName((String)context.getFirst());
            if (crate != null) {
                crate.getTiers().forEach(tier -> tiers.add(tier.getName()));
            }
            return tiers;
        });
        commandManager.registerSuggestion(SuggestionKey.of("numbers"), (sender, context) -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int i = 1; i <= 100; ++i) {
                numbers.add(String.valueOf(i));
            }
            return numbers;
        });
        commandManager.registerSuggestion(SuggestionKey.of("doubles"), (sender, context) -> {
            ArrayList<String> numbers = new ArrayList<String>();
            for (int count = 0; count <= 1000; ++count) {
                double x = (double)count / 10.0;
                numbers.add(String.valueOf(x));
            }
            return numbers;
        });
        commandManager.registerSuggestion(SuggestionKey.of("migrators"), (sender, context) -> {
            ArrayList<String> migrators = new ArrayList<String>();
            for (MigrationType value : MigrationType.values()) {
                String name = value.getName();
                migrators.add(name);
            }
            return migrators;
        });
        commandManager.registerArgument(PlayerBuilder.class, (sender, context) -> new PlayerBuilder(context));
        List.of(new CommandTeleport(), new CommandAddItem(), new CommandPreview(), new CommandDebug(), new CommandList(), new CommandEditor(), new CommandSet(), new CommandGive(), new CommandOpen(), new CommandTake(), new CommandMigrate(), new CommandReload(), new CommandAdmin(), new CommandTransfer(), new CommandKey(), new CommandClaim(), new CommandHelp()).forEach(commandManager::registerCommand);
    }

    @NotNull
    public static BukkitCommandManager<CommandSender> getCommandManager() {
        return commandManager;
    }
}

