/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.objects.gui.buttons;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.buttons.GuiButton;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.interfaces.GuiAction;
import libs.com.ryderbelserion.fusion.paper.api.builder.gui.interfaces.GuiItem;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateButton
extends GuiButton {
    private final BukkitUserManager userManager;
    private final CrateManager crateManager;
    private final Crate crate;
    private final Prize prize;

    public CrateButton(final Crate crate, final Prize prize, ConfigurationSection section) {
        super(section, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("%crate_pretty%", crate.getCrateName());
                this.put("%crate_raw%", crate.getFileName());
                this.put("%prize%", prize.getSectionName());
            }
        });
        this.userManager = this.plugin.getUserManager();
        this.crateManager = this.plugin.getCrateManager();
        this.crate = crate;
        this.prize = prize;
    }

    @Override
    @NotNull
    public final GuiItem getGuiItem() {
        GuiItem guiItem = super.getGuiItem();
        GuiAction<InventoryClickEvent> action = guiItem.getAction();
        guiItem.setAction(event -> {
            if (action != null) {
                action.execute((InventoryClickEvent)event);
            }
            final Player player = (Player)event.getWhoClicked();
            UUID uuid = player.getUniqueId();
            String crateName = this.crate.getFileName();
            switch (this.getSection().getName()) {
                case "accept": {
                    Prize prize = this.crate.getPrize(this.userManager.getRespinPrize(uuid, crateName));
                    PrizeManager.givePrize(player, this.crate, prize);
                    if (!this.crate.isCyclePersistRestart()) {
                        this.userManager.removeRespinCrate(uuid, crateName, this.userManager.getCrateRespin(uuid, crateName));
                    }
                    this.userManager.removeRespinPrize(uuid, crateName);
                    this.crateManager.removePlayerFromOpeningList(player);
                    this.crateManager.removeCrateInUse(player);
                    this.crateManager.removeCrateTask(player);
                    this.crateManager.endCrate(player);
                    break;
                }
                case "deny": {
                    if (PrizeManager.isCapped(this.crate, player)) {
                        Prize prize = this.crate.getPrize(this.userManager.getRespinPrize(uuid, crateName));
                        PrizeManager.givePrize(player, this.crate, prize);
                        this.userManager.removeRespinPrize(uuid, crateName);
                        if (!this.crate.isCyclePersistRestart()) {
                            this.userManager.removeRespinCrate(uuid, crateName, this.userManager.getCrateRespin(uuid, crateName));
                        }
                        final int cap = PrizeManager.getCap(this.crate, player);
                        Messages.crate_prize_max_respins.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                            {
                                this.put("{status}", cap >= 1 ? Messages.crate_prize_max_respins_left.getMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                                    {
                                        this.put("{respins_total}", String.valueOf(cap));
                                        this.put("{respins_left}", "0");
                                    }
                                }) : Messages.crate_prize_max_respins_none.getMessage((CommandSender)player));
                            }
                        });
                        return;
                    }
                    this.userManager.addRespinCrate(uuid, crateName, 1);
                    this.crateManager.openCrate(player, this.crate, KeyType.free_key, player.getLocation(), true, false, true, EventType.event_crate_opened);
                }
            }
        });
        return guiItem;
    }

    public final Crate getCrate() {
        return this.crate;
    }

    public final Prize getPrize() {
        return this.prize;
    }
}

