/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.objects;

import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateHologram;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.effects.SoundEffect;
import com.badbones69.crazycrates.paper.tasks.crates.other.AbstractCrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CratePreviewMenu;
import com.badbones69.crazycrates.paper.tasks.menus.CrateTierMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.files.LegacyCustomFile;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class Crate {
    private LegacyItemBuilder previewTierBorderItem;
    private LegacyItemBuilder borderItem;
    private LegacyItemBuilder keyBuilder;
    private AbstractCrateManager manager;
    private final String name;
    private String keyName;
    private int maxSlots;
    private String previewName;
    private boolean previewToggle;
    private boolean borderToggle;
    private boolean previewTierToggle;
    private boolean previewTierBorderToggle;
    private int previewTierCrateRows;
    private Color color;
    private Particle particle;
    private final CrateType crateType;
    private YamlConfiguration file;
    private ArrayList<Prize> prizes;
    private String crateName;
    private boolean giveNewPlayerKeys;
    private int previewChestLines;
    private int newPlayerKeys;
    private List<Tier> tiers;
    private CrateHologram hologram;
    private int maxMassOpen;
    private int requiredKeys;
    private boolean cyclePrize;
    private boolean cyclePersistRestart;
    private boolean cyclePermissionToggle;
    private int cyclePermissionCap;
    private List<String> prizeMessage = new ArrayList<String>();
    private List<String> prizeCommands = new ArrayList<String>();
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private boolean glassBorderToggle = true;
    private boolean broadcastToggle = false;
    private List<String> broadcastMessages = new ArrayList<String>();
    private String broadcastPermission = "";
    private double sum = 0.0;
    private double tierSum = 0.0;
    private String animationName;

    public Crate(@NotNull String name, @NotNull String previewName, @NotNull CrateType crateType, @NotNull LegacyItemBuilder key, @NotNull String keyName, @NotNull ArrayList<Prize> prizes, @NotNull YamlConfiguration file, int newPlayerKeys, @NotNull List<Tier> tiers, int maxMassOpen, int requiredKeys, @NotNull List<String> prizeMessage, @NotNull List<String> prizeCommands, @NotNull CrateHologram hologram) {
        this.keyBuilder = (LegacyItemBuilder)((LegacyItemBuilder)key.setDisplayName(keyName)).setPersistentString(ItemKeys.crate_key.getNamespacedKey(), name);
        this.keyName = keyName;
        this.file = file;
        this.name = name;
        this.tiers = tiers;
        this.maxMassOpen = maxMassOpen;
        this.requiredKeys = requiredKeys;
        this.prizeMessage = prizeMessage;
        this.prizeCommands = prizeCommands;
        this.glassBorderToggle = this.file.getBoolean("Crate.Settings.Border.Glass-Border.Toggle", this.glassBorderToggle);
        this.broadcastToggle = this.file.getBoolean("Crate.Settings.Broadcast.Toggle", false);
        this.broadcastMessages = this.file.getStringList("Crate.Settings.Broadcast.Messages");
        this.broadcastPermission = this.file.getString("Crate.Settings.Broadcast.Permission", "");
        this.cyclePrize = this.file.getBoolean("Crate.Settings.Rewards.Re-Roll-Spin", false);
        this.cyclePermissionToggle = this.file.getBoolean("Crate.Settings.Rewards.Permission.Toggle", false);
        this.cyclePersistRestart = this.file.getBoolean("Crate.Settings.Rewards.Permission.Persist", false);
        this.cyclePermissionCap = this.file.getInt("Crate.Settings.Rewards.Permission.Max-Cap", 20);
        for (int node = 1; node <= this.cyclePermissionCap; ++node) {
            if (this.cyclePermissionToggle) {
                MiscUtils.registerPermission("crazycrates.respin." + this.name + "." + node, "Allows you to open the crate " + this.name + node + " amount of times.", false);
                continue;
            }
            MiscUtils.unregisterPermission("crazycrates.respin." + this.name + "." + node);
        }
        if (this.broadcastToggle && !this.broadcastPermission.isEmpty()) {
            MiscUtils.registerPermission(this.broadcastPermission, "Hides the broadcast message if a player has this permission", false);
        } else if (!this.broadcastToggle && !this.broadcastPermission.isEmpty()) {
            MiscUtils.unregisterPermission(this.broadcastPermission);
        }
        this.prizes = prizes;
        this.sum = this.prizes.stream().filter(prize -> prize.getWeight() != -1.0).mapToDouble(Prize::getWeight).sum();
        this.crateType = crateType;
        this.previewToggle = file.getBoolean("Crate.Preview.Toggle", false);
        this.borderToggle = file.getBoolean("Crate.Preview.Glass.Toggle", false);
        this.previewTierToggle = file.getBoolean("Crate.tier-preview.toggle", false);
        this.previewTierBorderToggle = file.getBoolean("Crate.tier-preview.glass.toggle", false);
        this.previewName = previewName;
        this.newPlayerKeys = newPlayerKeys;
        this.giveNewPlayerKeys = newPlayerKeys > 0;
        this.setPreviewChestLines(file.getInt("Crate.Preview.ChestLines", 6));
        this.maxSlots = this.previewChestLines * 9;
        this.crateName = file.getString("Crate.Name", " ");
        this.animationName = file.getString("Crate.Animation.Name", this.crateName);
        @NotNull String borderName = file.getString("Crate.Preview.Glass.Name", " ");
        this.borderItem = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder().withType(file.getString("Crate.Preview.Glass.Item", "gray_stained_glass_pane").toLowerCase())).setCustomModelData(file.getString("Crate.Preview.Glass.Custom-Model-Data", ""))).setItemModel(file.getString("Crate.Preview.Glass.Model.Namespace", ""), file.getString("Crate.Preview.Glass.Model.Id", ""))).setHidingItemFlags(file.getBoolean("Crate.Preview.Glass.HideItemFlags", false))).setDisplayName(borderName);
        @NotNull String previewTierBorderName = file.getString("Crate.tier-preview.glass.name", " ");
        this.previewTierBorderItem = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder().withType(file.getString("Crate.tier-preview.glass.item", "gray_stained_glass_pane").toLowerCase())).setCustomModelData(file.getString("Crate.tier-preview.glass.custom-model-data", ""))).setItemModel(file.getString("Crate.tier-preview.glass.model.namespace", ""), file.getString("Crate.tier-preview.glass.model.id", ""))).setHidingItemFlags(file.getBoolean("Crate.tier-preview.glass.hideitemflags", false))).setDisplayName(previewTierBorderName);
        this.setTierPreviewRows(file.getInt("Crate.tier-preview.rows", 5));
        if (this.crateType == CrateType.quad_crate) {
            this.particle = ItemUtils.getParticleType(file.getString("Crate.particles.type", "dust"));
            this.color = ColorUtils.getColor(file.getString("Crate.particles.color", "235,64,52"));
        }
        this.hologram = hologram;
        switch (this.crateType) {
            case cosmic: {
                if (this.file != null) {
                    this.manager = new CosmicCrateManager(this.file);
                }
                this.tierSum = this.tiers.stream().filter(tier -> tier.getWeight() != -1.0).mapToDouble(Tier::getWeight).sum();
                break;
            }
            case casino: {
                this.tierSum = this.tiers.stream().filter(tier -> tier.getWeight() != -1.0).mapToDouble(Tier::getWeight).sum();
            }
        }
    }

    public Crate(@NotNull String name) {
        this.crateType = CrateType.menu;
        this.name = name;
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public Color getColor() {
        return this.color;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public final boolean isPreviewTierBorderToggle() {
        return this.previewTierBorderToggle;
    }

    public final boolean isPreviewTierToggle() {
        return this.previewTierToggle;
    }

    @NotNull
    public final LegacyItemBuilder getPreviewTierBorderItem() {
        return this.previewTierBorderItem;
    }

    @NotNull
    public final AbstractCrateManager getManager() {
        return this.manager;
    }

    public final boolean isGlassBorderToggled() {
        return this.glassBorderToggle;
    }

    public final boolean isBroadcastToggled() {
        return this.broadcastToggle;
    }

    @Deprecated(forRemoval=true, since="4.2.0")
    public final boolean isBroadcastToggle() {
        return this.isBroadcastToggled();
    }

    public final String getBroadcastPermission() {
        return this.broadcastPermission;
    }

    public final List<String> getBroadcastMessages() {
        return this.broadcastMessages;
    }

    public void setPreviewChestLines(int amount) {
        int finalAmount = this.borderToggle && amount < 3 ? 3 : Math.min(amount, 6);
        this.previewChestLines = finalAmount;
    }

    public void setTierPreviewRows(int amount) {
        this.previewTierCrateRows = amount;
    }

    public final int getPreviewTierCrateRows() {
        return this.previewTierCrateRows;
    }

    public final int getPreviewChestLines() {
        return this.previewChestLines;
    }

    public final int getMaxSlots() {
        return this.maxSlots;
    }

    public final boolean canWinPrizes(@NotNull Player player) {
        return this.pickPrize(player) != null;
    }

    @NotNull
    public final List<String> getPrizeMessage() {
        return this.prizeMessage;
    }

    @NotNull
    public final List<String> getPrizeCommands() {
        return this.prizeCommands;
    }

    public Prize pickPrize(@NotNull Player player) {
        ArrayList<Prize> prizes = new ArrayList<Prize>();
        for (Prize prize : this.getPrizes()) {
            if (this.validatePrize(player, prize)) continue;
            prizes.add(prize);
        }
        return this.getPrize(prizes);
    }

    public final Prize pickPrize(@NotNull Player player, @NotNull Tier tier) {
        ArrayList<Prize> prizes = new ArrayList<Prize>();
        for (Prize prize : this.getPrizes()) {
            if (this.validatePrize(player, prize) || !prize.getTiers().contains(tier)) continue;
            prizes.add(prize);
        }
        return this.getPrize(prizes);
    }

    private boolean validatePrize(@NotNull Player player, Prize prize) {
        boolean hasPermission;
        if (prize.getWeight() == -1.0) {
            return true;
        }
        int pulls = PrizeManager.getCurrentPulls(prize, this);
        if (pulls != 0 && pulls >= prize.getMaxPulls()) {
            return true;
        }
        boolean bl = hasPermission = !player.isOp() && prize.hasPermission(player);
        if (hasPermission) {
            return prize.hasAlternativePrize();
        }
        return false;
    }

    private Prize getPrize(@NotNull List<Prize> prizes) {
        int index;
        double totalWeight = this.crateType == CrateType.casino || this.crateType == CrateType.cosmic ? prizes.stream().filter(prize -> prize.getWeight() != -1.0).mapToDouble(Prize::getWeight).sum() : this.sum;
        double value = MiscUtils.getRandom().nextDouble() * totalWeight;
        for (index = 0; index < prizes.size() - 1 && !((value -= prizes.get(index).getWeight()) < 0.0); ++index) {
        }
        return prizes.get(index);
    }

    public double getChance(double weight) {
        return weight / this.sum * 100.0;
    }

    public double getTierChance(double weight) {
        return weight / this.tierSum * 100.0;
    }

    public void setPrize(@NotNull List<Prize> prizes) {
        this.purge();
        this.prizes.addAll(prizes.stream().filter(prize -> prize.getWeight() != -1.0).toList());
    }

    public void purge() {
        this.prizes.clear();
    }

    public final boolean isCyclePermissionToggle() {
        return this.cyclePermissionToggle;
    }

    public final int getCyclePermissionCap() {
        return this.cyclePermissionCap;
    }

    @NotNull
    public final String getFileName() {
        return this.name;
    }

    @NotNull
    public final String getPreviewName() {
        return this.previewName;
    }

    public final boolean isPreviewEnabled() {
        return this.previewToggle;
    }

    public final boolean isBorderToggle() {
        return this.borderToggle;
    }

    @NotNull
    public final LegacyItemBuilder getBorderItem() {
        return this.borderItem;
    }

    @NotNull
    public final String getCrateName() {
        return this.crateName;
    }

    public final CratePreviewMenu getPreview(Player player) {
        return this.getPreview(player, null);
    }

    public final CratePreviewMenu getPreview(Player player, @Nullable Tier tier) {
        return new CratePreviewMenu(player, this, tier);
    }

    public final CrateTierMenu getTierPreview(Player player) {
        return new CrateTierMenu(player, this);
    }

    public final CrateType getCrateType() {
        return this.crateType;
    }

    @NotNull
    public final ItemStack getKey() {
        return this.keyBuilder.asItemStack();
    }

    @NotNull
    public final ItemStack getKey(Player player) {
        return this.userManager.addPlaceholders((LegacyItemBuilder)this.keyBuilder.setPlayer(player), this).asItemStack();
    }

    @NotNull
    public final ItemStack getKey(int amount) {
        return ((LegacyItemBuilder)this.keyBuilder.setAmount(amount)).asItemStack();
    }

    @NotNull
    public final ItemStack getKey(int amount, Player player) {
        return ((LegacyItemBuilder)this.userManager.addPlaceholders((LegacyItemBuilder)this.keyBuilder.setPlayer(player), this).setAmount(amount)).asItemStack();
    }

    @NotNull
    public final YamlConfiguration getFile() {
        return this.file;
    }

    @NotNull
    public final List<Prize> getPrizes() {
        return this.prizes;
    }

    public final double getSum() {
        return this.sum;
    }

    @Nullable
    public final Prize getPrize(@NotNull String name) {
        if (name.isEmpty()) {
            return null;
        }
        Prize prize = null;
        for (Prize key : this.prizes) {
            if (!key.getSectionName().equalsIgnoreCase(name)) continue;
            prize = key;
            break;
        }
        return prize;
    }

    @Nullable
    public final Prize getPrize(@NotNull ItemStack item) {
        return this.getPrize((String)item.getPersistentDataContainer().getOrDefault(ItemKeys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)""));
    }

    public final boolean doNewPlayersGetKeys() {
        return this.giveNewPlayerKeys;
    }

    public final int getNewPlayerKeys() {
        return this.newPlayerKeys;
    }

    public void addEditorItem(@Nullable ItemStack itemStack, @NotNull String prizeName, double weight) {
        if (itemStack == null || prizeName.isEmpty() || weight <= 0.0) {
            return;
        }
        ConfigurationSection section = this.getPrizeSection();
        this.setItem(itemStack, prizeName, section, weight, "");
    }

    public void addEditorItem(@Nullable ItemStack itemStack, @NotNull String prizeName, @NotNull String tier, double weight) {
        if (tier.isEmpty() || prizeName.isEmpty() || weight <= 0.0 || itemStack == null) {
            return;
        }
        ConfigurationSection section = this.getPrizeSection();
        this.setItem(itemStack, prizeName, section, weight, tier);
    }

    @NotNull
    public final ConfigurationSection getPrizeSection() {
        ConfigurationSection prizeSection;
        ConfigurationSection section = this.file.getConfigurationSection("Crate");
        if (section == null) {
            section = this.file.createSection("Crate");
        }
        if ((prizeSection = section.getConfigurationSection("Prizes")) == null) {
            prizeSection = section.createSection("Prizes");
        }
        return prizeSection;
    }

    private void setItem(@Nullable ItemStack itemStack, @NotNull String prizeName, @Nullable ConfigurationSection section, double weight, final String tier) {
        if (prizeName.isEmpty() || section == null || weight <= 0.0 || itemStack == null) {
            return;
        }
        String tiers = this.getPath(prizeName, "Tiers");
        if (itemStack.hasItemMeta()) {
            List lore;
            Component displayName;
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasDisplayName() && (displayName = itemMeta.displayName()) != null) {
                section.set(this.getPath(prizeName, "DisplayName"), (Object)AdvUtils.fromComponent(displayName));
            }
            if (itemMeta.hasLore() && (lore = itemMeta.lore()) != null) {
                section.set(this.getPath(prizeName, "DisplayLore"), AdvUtils.fromComponent(lore));
            }
        }
        String path = this.getPath(prizeName, "Items");
        String toBase64 = ItemUtils.toBase64(itemStack);
        if (!section.contains(path)) {
            boolean isNewLayout = ConfigManager.getConfig().getProperty(ConfigKeys.use_different_items_layout);
            if (isNewLayout) {
                section.createSection(path);
            } else {
                section.set(path, new ArrayList());
            }
        }
        section.set(this.getPath(prizeName, "DisplayData"), (Object)toBase64);
        boolean isList = section.isList(path);
        if (isList) {
            List list = section.getStringList(path);
            list.add("Data:" + toBase64);
            section.set(path, (Object)list);
        } else {
            ConfigurationSection items = section.getConfigurationSection(path);
            if (items == null) {
                items = section.createSection(path);
            }
            items.set(MiscUtils.randomUUID() + ".data", (Object)toBase64);
        }
        section.set(this.getPath(prizeName, "DisplayItem"), (Object)itemStack.getType().getKey().getKey());
        section.set(this.getPath(prizeName, "DisplayAmount"), (Object)itemStack.getAmount());
        ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
        for (Map.Entry enchantment : itemStack.getEnchantments().entrySet()) {
            enchantments.add((CallSite)((Object)(((Enchantment)enchantment.getKey()).getKey().getKey() + ":" + String.valueOf(enchantment.getValue()))));
        }
        if (!enchantments.isEmpty()) {
            section.set(this.getPath(prizeName, "DisplayEnchantments"), enchantments);
        }
        section.set(this.getPath(prizeName, "Weight"), (Object)weight);
        if (!tier.isEmpty()) {
            if (section.contains(tiers)) {
                List list = section.getStringList(tiers);
                list.add(tier);
                section.set(tiers, (Object)list);
            } else {
                section.set(tiers, (Object)new ArrayList<Object>(){
                    {
                        this.add(tier);
                    }
                });
            }
        }
        this.saveFile();
    }

    @NotNull
    private String getPath(String section, String path) {
        if (section.isEmpty() || path.isEmpty()) {
            return "";
        }
        return section + "." + path;
    }

    private void saveFile() {
        if (this.name.isEmpty()) {
            return;
        }
        LegacyCustomFile customFile = this.plugin.getFileManager().getFile(this.name, FileType.YAML);
        if (customFile != null) {
            customFile.save();
        }
        this.crateManager.reloadCrate(this.crateManager.getCrateFromName(this.name));
    }

    @NotNull
    public final List<Tier> getTiers() {
        return this.tiers;
    }

    @Nullable
    public final Tier getTier(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Tier tier = null;
        for (Tier key : this.tiers) {
            if (!key.getName().equalsIgnoreCase(name)) continue;
            tier = key;
            break;
        }
        return tier;
    }

    public final int getMaxMassOpen() {
        return this.maxMassOpen;
    }

    public final int getRequiredKeys() {
        return this.requiredKeys;
    }

    @NotNull
    public final CrateHologram getHologram() {
        return this.hologram;
    }

    @NotNull
    public final List<ItemStack> getPreviewItems(@Nullable Player player, @Nullable Tier tier) {
        ArrayList<ItemStack> prizes = new ArrayList<ItemStack>();
        for (Prize prize : this.getPrizes()) {
            if (tier == null) {
                prizes.add(player == null ? prize.getDisplayItem(this) : prize.getDisplayItem(player, this));
                continue;
            }
            if (!prize.getTiers().contains(tier)) continue;
            prizes.add(player == null ? prize.getDisplayItem(this) : prize.getDisplayItem(player, this));
        }
        return prizes;
    }

    public final boolean isCyclePersistRestart() {
        return this.cyclePersistRestart;
    }

    public final boolean isCyclePrize() {
        return this.cyclePrize;
    }

    public final boolean useRequiredKeys() {
        return ConfigManager.getConfig().getProperty(ConfigKeys.crate_use_required_keys) != false && this.requiredKeys > 0;
    }

    public void playSound(@NotNull Player player, @NotNull Location location, @NotNull String type, @NotNull String fallback, @NotNull Sound.Source source) {
        if (type.isEmpty() && fallback.isEmpty()) {
            return;
        }
        ConfigurationSection section = this.getFile().getConfigurationSection("Crate.sound");
        if (section != null) {
            SoundEffect sound = new SoundEffect(section, type, fallback, source);
            sound.play(player, location);
        }
    }
}

