/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.events;

import com.badbones69.crazycrates.paper.api.objects.Crate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerReceiveKeyEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final OfflinePlayer offlinePlayer;
    private final Crate crate;
    private final KeyReceiveReason reason;
    private final int amount;
    private boolean isCancelled;

    public PlayerReceiveKeyEvent(@NotNull Player player, @NotNull Crate crate, @NotNull KeyReceiveReason reason, int amount) {
        this.player = player;
        this.offlinePlayer = null;
        this.crate = crate;
        this.reason = reason;
        this.amount = amount;
        this.isCancelled = false;
    }

    public PlayerReceiveKeyEvent(@NotNull OfflinePlayer player, @NotNull Crate crate, @NotNull KeyReceiveReason reason, int amount) {
        this.player = null;
        this.offlinePlayer = player;
        this.crate = crate;
        this.reason = reason;
        this.amount = amount;
        this.isCancelled = false;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nullable
    public final Player getPlayer() {
        return this.player;
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public KeyReceiveReason getReason() {
        return this.reason;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public final int getAmount() {
        return this.amount;
    }

    public static enum KeyReceiveReason {
        GIVE_COMMAND,
        GIVE_ALL_COMMAND,
        OFFLINE_PLAYER,
        REFUND,
        TRANSFER;

    }
}

