/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.events;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.nexomc.nexo.api.NexoFurniture;
import com.nexomc.nexo.api.events.furniture.NexoFurnitureBreakEvent;
import com.nexomc.nexo.api.events.furniture.NexoFurnitureInteractEvent;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureBreakEvent;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureInteractEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class CrateInteractEvent
extends Event
implements Cancellable {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();
    private NexoFurnitureInteractEvent nexoInteractEvent;
    private NexoFurnitureBreakEvent nexoBreakEvent;
    private OraxenFurnitureInteractEvent oraxenInteractEvent;
    private OraxenFurnitureBreakEvent oraxenBreakEvent;
    private PlayerInteractEvent paperEvent;
    private CrateLocation crateLocation = null;
    private boolean isCancelled;
    private final EquipmentSlot slot;
    private final Location location;
    private final Player player;
    private final Action action;
    private static final HandlerList handlers = new HandlerList();

    public CrateInteractEvent(@NotNull OraxenFurnitureInteractEvent interactEvent, @NotNull Action action, @NotNull Location location) {
        this.oraxenInteractEvent = interactEvent;
        this.player = this.oraxenInteractEvent.getPlayer();
        this.slot = this.oraxenInteractEvent.getHand();
        this.location = location;
        this.action = action;
        this.setCancelled(this.slot == EquipmentSlot.OFF_HAND);
        if (!this.isCancelled()) {
            this.crateLocation = this.crateManager.getCrateLocation(this.location);
        }
    }

    public CrateInteractEvent(@NotNull OraxenFurnitureBreakEvent breakEvent, @NotNull Action action, @NotNull Location location) {
        this.oraxenBreakEvent = breakEvent;
        this.player = this.oraxenBreakEvent.getPlayer();
        this.slot = this.player.getActiveItemHand();
        this.location = location;
        this.action = action;
        this.setCancelled(this.slot == EquipmentSlot.OFF_HAND);
        if (!this.isCancelled()) {
            this.crateLocation = this.crateManager.getCrateLocation(this.location);
        }
    }

    public CrateInteractEvent(@NotNull NexoFurnitureInteractEvent interactEvent, @NotNull Action action, @NotNull Location location) {
        this.nexoInteractEvent = interactEvent;
        this.player = this.nexoInteractEvent.getPlayer();
        this.slot = this.nexoInteractEvent.getHand();
        this.location = location;
        this.action = action;
        this.setCancelled(this.slot == EquipmentSlot.OFF_HAND);
        if (!this.isCancelled()) {
            this.crateLocation = this.crateManager.getCrateLocation(this.location);
        }
    }

    public CrateInteractEvent(@NotNull NexoFurnitureBreakEvent breakEvent, @NotNull Action action, @NotNull Location location) {
        this.nexoBreakEvent = breakEvent;
        this.player = this.nexoBreakEvent.getPlayer();
        this.slot = this.player.getActiveItemHand();
        this.location = location;
        this.action = action;
        this.setCancelled(this.slot == EquipmentSlot.OFF_HAND || !this.isFurniture(location));
        if (!this.isCancelled()) {
            this.crateLocation = this.crateManager.getCrateLocation(this.location);
        }
    }

    public CrateInteractEvent(@NotNull PlayerInteractEvent paperEvent, @NotNull Location location) {
        this.paperEvent = paperEvent;
        this.player = this.paperEvent.getPlayer();
        this.action = this.paperEvent.getAction();
        this.slot = this.paperEvent.getHand();
        this.location = location;
        this.setCancelled(this.slot == EquipmentSlot.OFF_HAND || this.isFurniture(location));
        if (!this.isCancelled()) {
            this.crateLocation = this.crateManager.getCrateLocation(this.location);
        }
    }

    public boolean isFurniture(Location location) {
        String pluginName = this.plugin.getFusion().getItemsPlugin().toLowerCase();
        boolean isFurniture = false;
        switch (pluginName) {
            case "nexo": {
                isFurniture = Plugins.nexo.isEnabled() && NexoFurniture.isFurniture((Location)location);
                break;
            }
            case "oraxen": {
                isFurniture = Plugins.oraxen.isEnabled() && OraxenFurniture.isFurniture((Block)location.getBlock());
                break;
            }
            default: {
                if (Plugins.nexo.isEnabled() && NexoFurniture.isFurniture((Location)location)) {
                    isFurniture = true;
                    break;
                }
                if (!Plugins.oraxen.isEnabled() || !OraxenFurniture.isFurniture((Block)location.getBlock())) break;
                isFurniture = true;
            }
        }
        return isFurniture;
    }

    public void cancel() {
        if (this.nexoInteractEvent != null) {
            this.nexoInteractEvent.setCancelled(true);
            return;
        }
        if (this.nexoBreakEvent != null) {
            this.nexoBreakEvent.setCancelled(true);
            return;
        }
        if (this.oraxenInteractEvent != null) {
            this.oraxenInteractEvent.setCancelled(true);
            return;
        }
        if (this.oraxenBreakEvent != null) {
            this.oraxenBreakEvent.setCancelled(true);
            return;
        }
        if (this.paperEvent != null) {
            this.paperEvent.setCancelled(true);
        }
    }

    @NotNull
    public CrateLocation getCrateLocation() {
        return this.crateLocation;
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }
}

