/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper;

import com.badbones69.crazycrates.core.Server;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.commands.CommandManager;
import com.badbones69.crazycrates.paper.listeners.BrokeLocationsListener;
import com.badbones69.crazycrates.paper.listeners.CrateControlListener;
import com.badbones69.crazycrates.paper.listeners.MiscListener;
import com.badbones69.crazycrates.paper.listeners.crates.CrateInteractListener;
import com.badbones69.crazycrates.paper.listeners.crates.CrateOpenListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.CosmicCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.MobileCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.QuadCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.WarCrateListener;
import com.badbones69.crazycrates.paper.listeners.items.PaperInteractListener;
import com.badbones69.crazycrates.paper.listeners.other.EntityDamageListener;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.support.MetricsWrapper;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.support.placeholders.PlaceholderAPISupport;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import libs.com.ryderbelserion.fusion.api.enums.FileType;
import libs.com.ryderbelserion.fusion.core.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.files.LegacyFileManager;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CrazyCrates
extends JavaPlugin {
    private final Timer timer;
    private final long startTime = System.nanoTime();
    private InventoryManager inventoryManager;
    private BukkitUserManager userManager;
    private CrateManager crateManager;
    private FusionPaper api;
    private Server instance;
    private MetricsWrapper metrics;
    private LegacyFileManager fileManager;

    public static CrazyCrates getPlugin() {
        return (CrazyCrates)JavaPlugin.getPlugin(CrazyCrates.class);
    }

    public CrazyCrates() {
        this.timer = new Timer();
    }

    public void onEnable() {
        this.api = new FusionPaper(this.getComponentLogger(), this.getDataPath());
        this.api.enable((Plugin)this);
        this.fileManager = this.api.getLegacyFileManager();
        this.instance = new Server(this.getDataFolder());
        this.instance.apply();
        this.fileManager.addFile("locations.yml", FileType.YAML).addFile("data.yml", FileType.YAML).addFile("respin-gui.yml", "guis", false, FileType.YAML).addFile("crates.log", "logs", false, FileType.NONE).addFile("keys.log", "logs", false, FileType.NONE).addFolder("crates", FileType.YAML).addFolder("schematics", FileType.NONE);
        MiscUtils.janitor();
        MiscUtils.save();
        MiscUtils.registerPermissions();
        this.inventoryManager = new InventoryManager();
        this.crateManager = new CrateManager();
        this.userManager = new BukkitUserManager();
        this.instance.setUserManager(this.userManager);
        this.crateManager.loadHolograms();
        this.inventoryManager.loadButtons();
        this.crateManager.loadCrates();
        if (ConfigManager.getConfig().getProperty(ConfigKeys.toggle_metrics).booleanValue()) {
            this.metrics = new MetricsWrapper(4514);
            this.metrics.start();
        }
        CommandManager.load();
        PluginManager manager = this.getServer().getPluginManager();
        List.of(new BrokeLocationsListener(), new EntityDamageListener(), new MobileCrateListener(), new CosmicCrateListener(), new QuadCrateListener(), new WarCrateListener(), new MiscListener(), new CrateInteractListener(), new CrateControlListener(), new CrateOpenListener(), new PaperInteractListener()).forEach(listener -> manager.registerEvents(listener, (Plugin)this));
        this.crateManager.loadCustomItems();
        if (Plugins.placeholder_api.isEnabled()) {
            if (MiscUtils.isLogging()) {
                this.getComponentLogger().info("PlaceholderAPI support is enabled!");
            }
            new PlaceholderAPISupport().register();
        }
        if (MiscUtils.isLogging()) {
            for (Plugins value : Plugins.values()) {
                if (value.isEnabled()) {
                    this.getComponentLogger().info(AdvUtils.parse("<bold><gold>" + value.getName() + " <green>FOUND"));
                    continue;
                }
                this.getComponentLogger().info(AdvUtils.parse("<bold><gold>" + value.getName() + " <red>NOT FOUND"));
            }
            this.getComponentLogger().info("Done ({})!", (Object)String.format(Locale.ROOT, "%.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
        }
    }

    public void onDisable() {
        this.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)this);
        this.getServer().getAsyncScheduler().cancelTasks((Plugin)this);
        this.timer.cancel();
        if (this.crateManager != null) {
            this.crateManager.purgeRewards();
            HologramManager holograms = this.crateManager.getHolograms();
            if (holograms != null) {
                holograms.purge(true);
            }
        }
        if (this.instance != null) {
            this.instance.disable();
        }
        MiscUtils.janitor();
        this.api.save();
    }

    public final InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public final BukkitUserManager getUserManager() {
        return this.userManager;
    }

    public final CrateManager getCrateManager() {
        return this.crateManager;
    }

    public final Server getInstance() {
        return this.instance;
    }

    public final MetricsWrapper getMetrics() {
        return this.metrics;
    }

    public final LegacyFileManager getFileManager() {
        return this.fileManager;
    }

    public final Timer getTimer() {
        return this.timer;
    }

    public final FusionPaper getFusion() {
        return this.api;
    }
}

