/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import ch.jalu.typeresolver.CommonTypeUtils;
import ch.jalu.typeresolver.array.ArrayTypeUtils;
import ch.jalu.typeresolver.typeimpl.ParameterizedTypeImpl;
import ch.jalu.typeresolver.typeimpl.WildcardTypeImpl;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class TypeVariableResolver {
    private final Map<TypeVariableData, Type> typeRules = new HashMap<TypeVariableData, Type>();

    TypeVariableResolver(Type type) {
        this.registerTypes(type, new HashSet());
    }

    Type resolve(Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type lookedUpType = this.typeRules.get(new TypeVariableData(tv));
            if (lookedUpType != null) {
                return this.resolve(lookedUpType);
            }
        } else {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type[] resolvedTypes = this.resolveTypes(pt.getActualTypeArguments());
                return new ParameterizedTypeImpl(CommonTypeUtils.getRawType(pt), pt.getOwnerType(), resolvedTypes);
            }
            if (type instanceof WildcardType) {
                WildcardType wt = (WildcardType)type;
                Type[] upperBounds = this.resolveTypes(wt.getUpperBounds());
                Type[] lowerBounds = this.resolveTypes(wt.getLowerBounds());
                return new WildcardTypeImpl(upperBounds, lowerBounds);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)type;
                Type resolvedComponentType = this.resolve(gat.getGenericComponentType());
                return ArrayTypeUtils.createArrayType(resolvedComponentType);
            }
        }
        return type;
    }

    Type[] resolveTypes(Type[] types) {
        Type[] resolvedTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = this.resolve(types[i]);
        }
        return resolvedTypes;
    }

    private void registerTypes(Type type, Set<Class<?>> processedClasses) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.registerTypesFromParentAndInterfaces(clazz, processedClasses);
            this.registerTypes(clazz.getEnclosingClass(), processedClasses);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            this.registerParameterizedTypes(pt, processedClasses);
            this.registerTypesFromParentAndInterfaces(CommonTypeUtils.getRawType(pt), processedClasses);
            this.registerTypes(pt.getOwnerType(), processedClasses);
        }
    }

    private void registerTypesFromParentAndInterfaces(Class<?> clazz, Set<Class<?>> processedClasses) {
        for (Class<?> currentClass = clazz; !Object.class.equals(currentClass) && currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.registerTypes(currentClass.getGenericSuperclass(), processedClasses);
            for (Type genericInterfaceType : currentClass.getGenericInterfaces()) {
                this.registerTypes(genericInterfaceType, processedClasses);
            }
        }
    }

    private void registerParameterizedTypes(ParameterizedType parameterizedType, Set<Class<?>> processedClasses) {
        Class<?> rawType = CommonTypeUtils.getRawType(parameterizedType);
        if (processedClasses.contains(rawType)) {
            return;
        }
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeArguments.length; ++i) {
            this.typeRules.put(new TypeVariableData(rawType.getTypeParameters()[i]), typeArguments[i]);
        }
        processedClasses.add(rawType);
    }

    private static final class TypeVariableData {
        private final GenericDeclaration declarer;
        private final String name;

        TypeVariableData(TypeVariable<?> tv) {
            this.declarer = tv.getGenericDeclaration();
            this.name = tv.getName();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TypeVariableData) {
                TypeVariableData that = (TypeVariableData)obj;
                return Objects.equals(this.declarer, that.declarer) && Objects.equals(this.name, that.name);
            }
            return false;
        }

        public int hashCode() {
            return this.declarer.hashCode() ^ this.name.hashCode();
        }
    }
}

