/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.internal.PathUtils;
import ch.jalu.configme.resource.MapNormalizer;
import ch.jalu.configme.resource.PropertyReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlFileReader
implements PropertyReader {
    private final Path path;
    private final Charset charset;
    @Nullable
    private final Map<String, Object> root;

    public YamlFileReader(@NotNull Path path) {
        this(path, StandardCharsets.UTF_8);
    }

    public YamlFileReader(@NotNull Path path, @NotNull Charset charset) {
        this.path = path;
        this.charset = charset;
        this.root = this.loadFile();
    }

    @Override
    @Nullable
    public Object getObject(@NotNull String path) {
        String[] keys;
        if (path.isEmpty()) {
            return this.root;
        }
        Object node = this.root;
        for (String key : keys = path.split("\\.")) {
            if ((node = YamlFileReader.getEntryIfIsMap(key, node)) != null) continue;
            return null;
        }
        return node;
    }

    @Override
    @Nullable
    public String getString(@NotNull String path) {
        return this.getTypedObject(path, String.class);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String path) {
        Number n = this.getTypedObject(path, Number.class);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull String path) {
        Number n = this.getTypedObject(path, Number.class);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String path) {
        return this.getTypedObject(path, Boolean.class);
    }

    @Override
    @Nullable
    public List<?> getList(@NotNull String path) {
        return this.getTypedObject(path, List.class);
    }

    @Override
    public boolean contains(@NotNull String path) {
        return this.getObject(path) != null;
    }

    @Override
    @NotNull
    public Set<String> getKeys(boolean onlyLeafNodes) {
        if (this.root == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> allKeys = new LinkedHashSet<String>();
        this.collectKeysIntoSet("", this.root, allKeys, onlyLeafNodes);
        return allKeys;
    }

    @Override
    @NotNull
    public Set<String> getChildKeys(@NotNull String path) {
        Object object = this.getObject(path);
        if (object instanceof Map) {
            Object pathPrefix = path.isEmpty() ? "" : path + ".";
            return ((Map)object).keySet().stream().map(arg_0 -> YamlFileReader.lambda$getChildKeys$0((String)pathPrefix, arg_0)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    private void collectKeysIntoSet(@NotNull String path, @NotNull Map<String, Object> map, @NotNull Set<String> result, boolean onlyLeafNodes) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String childPath = PathUtils.concat(path, entry.getKey());
            if (!onlyLeafNodes || YamlFileReader.isLeafValue(entry.getValue())) {
                result.add(childPath);
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.collectKeysIntoSet(childPath, (Map)entry.getValue(), result, onlyLeafNodes);
        }
    }

    private static boolean isLeafValue(@Nullable Object o) {
        return !(o instanceof Map) || ((Map)o).isEmpty();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected Map<String, Object> loadFile() {
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            Map<String, Object> map;
            try (InputStreamReader isr = new InputStreamReader(is, this.charset);){
                Map rootMap = (Map)new Yaml().load(isr);
                map = this.normalizeMap(rootMap);
            }
            return map;
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not read file '" + String.valueOf(this.path) + "'", e);
        }
        catch (ClassCastException e) {
            throw new ConfigMeException("Top-level is not a map in '" + String.valueOf(this.path) + "'", e);
        }
        catch (YAMLException e) {
            throw new ConfigMeException("YAML error while trying to load file '" + String.valueOf(this.path) + "'", e);
        }
    }

    @Nullable
    protected Map<String, Object> normalizeMap(@Nullable Map<Object, Object> map) {
        return new MapNormalizer().normalizeMap(map);
    }

    @NotNull
    protected final Path getPath() {
        return this.path;
    }

    @Deprecated
    @Nullable
    protected final Map<String, Object> getRoot() {
        return this.root;
    }

    @Nullable
    protected <T> T getTypedObject(@NotNull String path, @NotNull Class<T> clazz) {
        Object value = this.getObject(path);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Nullable
    private static Object getEntryIfIsMap(@NotNull String key, @Nullable Object value) {
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        return null;
    }

    private static /* synthetic */ String lambda$getChildKeys$0(String pathPrefix, String childPath) {
        return pathPrefix + childPath;
    }
}

