/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyAndLeafType;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexType
extends PropertyAndLeafType<Pattern> {
    public static final RegexType REGEX = new RegexType();
    public static final RegexType REGEX_CASE_INSENSITIVE = new RegexType(){

        @Override
        @NotNull
        protected Pattern compileToPattern(@NotNull String regex) {
            return Pattern.compile(regex, 2);
        }
    };

    protected RegexType() {
        super(Pattern.class);
    }

    @Override
    @Nullable
    public Pattern convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof String) {
            String regex = (String)object;
            try {
                return this.compileToPattern(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object toExportValue(@NotNull Pattern value) {
        return value.pattern();
    }

    @NotNull
    protected Pattern compileToPattern(@NotNull String regex) {
        return Pattern.compile(regex);
    }
}

