/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.types.EnumSetPropertyType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EnumSetProperty<E extends Enum<E>>
extends SetProperty<E> {
    public EnumSetProperty(@NotNull String path, @NotNull Class<E> enumClass, @NotNull EnumSet<E> defaultValue) {
        super(new EnumSetPropertyType<E>(enumClass), path, defaultValue);
    }

    public EnumSetProperty(@NotNull String path, @NotNull Class<E> enumClass, E ... defaultValue) {
        super(new EnumSetPropertyType<E>(enumClass), path, EnumSetProperty.newEnumSet(enumClass, defaultValue));
    }

    @NotNull
    private static <E extends Enum<E>> Set<E> newEnumSet(@NotNull Class<E> enumClass, E @NotNull [] defaultValue) {
        EnumSet<E> enumSet = EnumSet.noneOf(enumClass);
        enumSet.addAll(Arrays.asList(defaultValue));
        return enumSet;
    }
}

