/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.beanmapper.DefaultMapper;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.types.BeanPropertyType;
import ch.jalu.typeresolver.TypeInfo;
import org.jetbrains.annotations.NotNull;

public class BeanProperty<T>
extends TypeBasedProperty<T> {
    public BeanProperty(@NotNull String path, @NotNull Class<T> beanType, @NotNull T defaultValue) {
        this(path, beanType, defaultValue, DefaultMapper.getInstance());
    }

    public BeanProperty(@NotNull String path, @NotNull Class<T> beanType, @NotNull T defaultValue, @NotNull Mapper mapper) {
        super(path, BeanPropertyType.of(beanType, mapper), defaultValue);
    }

    public BeanProperty(@NotNull String path, @NotNull BeanPropertyType<T> type, @NotNull T defaultValue) {
        super(path, type, defaultValue);
    }

    protected BeanProperty(@NotNull String path, @NotNull TypeInfo beanType, @NotNull T defaultValue, @NotNull Mapper mapper) {
        super(path, new BeanPropertyType(beanType, mapper), defaultValue);
        Class<?> beanClass = beanType.toClass();
        if (beanClass == null) {
            throw new IllegalArgumentException("The bean type '" + String.valueOf(beanType) + "' cannot be converted to Class. Use a constructor with a custom BeanPropertyType.");
        }
        if (!beanClass.isInstance(defaultValue)) {
            throw new ConfigMeException("Default value for path '" + path + "' does not match bean type '" + String.valueOf(beanType) + "'");
        }
    }
}

