/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.configurationdata;

import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropertyListBuilder {
    @NotNull
    private final Map<String, Object> rootEntries = new LinkedHashMap<String, Object>();

    public void add(@NotNull Property<?> property) {
        String lastElement;
        String[] pathElements = property.getPath().split("\\.", -1);
        Map<String, Object> mapForProperty = this.getMapBeforeLastElement(pathElements);
        if (mapForProperty.containsKey(lastElement = pathElements[pathElements.length - 1])) {
            throw new ConfigMeException("Path at '" + property.getPath() + "' already exists");
        }
        if (pathElements.length > 1 && "".equals(lastElement)) {
            this.throwExceptionForMalformedPath(property.getPath());
        }
        mapForProperty.put(lastElement, property);
    }

    @NotNull
    public List<Property<?>> create() {
        ArrayList result = new ArrayList();
        PropertyListBuilder.collectEntries(this.rootEntries, result);
        if (result.size() > 1 && this.rootEntries.containsKey("")) {
            throw new ConfigMeException("A property at the root path (\"\") cannot be defined alongside other properties as the paths would conflict");
        }
        return result;
    }

    @NotNull
    protected Map<String, Object> getMapBeforeLastElement(String @NotNull [] pathParts) {
        Map<String, Object> map = this.rootEntries;
        for (int i = 0; i < pathParts.length - 1; ++i) {
            map = PropertyListBuilder.getChildMap(map, pathParts[i]);
            if (!pathParts[i].equals("")) continue;
            this.throwExceptionForMalformedPath(String.join((CharSequence)".", pathParts));
        }
        return map;
    }

    protected void throwExceptionForMalformedPath(@NotNull String path) {
        throw new ConfigMeException("The path at '" + path + "' is malformed: dots may not be at the beginning or end of a path, and dots may not appear multiple times successively.");
    }

    @NotNull
    protected final Map<String, Object> getRootEntries() {
        return this.rootEntries;
    }

    @NotNull
    private static Map<String, Object> getChildMap(@NotNull Map<String, Object> parent, @NotNull String path) {
        Object o = parent.get(path);
        if (o instanceof Map) {
            return PropertyListBuilder.asTypedMap(o);
        }
        if (o == null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            parent.put(path, map);
            return map;
        }
        if (o instanceof Property) {
            throw new ConfigMeException("Unexpected entry found at path '" + path + "'");
        }
        throw new ConfigMeException("Value of unknown type found at '" + path + "': " + String.valueOf(o));
    }

    private static void collectEntries(@NotNull Map<String, Object> map, @NotNull List<Property<?>> results) {
        for (Object o : map.values()) {
            if (o instanceof Map) {
                PropertyListBuilder.collectEntries(PropertyListBuilder.asTypedMap(o), results);
                continue;
            }
            if (!(o instanceof Property)) continue;
            results.add((Property)o);
        }
    }

    @NotNull
    private static Map<String, Object> asTypedMap(@NotNull Object o) {
        return (Map)o;
    }
}

