/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.command.InternalBranchCommand;
import dev.triumphteam.cmd.core.command.InternalCommand;
import dev.triumphteam.cmd.core.command.InternalLeafCommand;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.command.Settings;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.extension.registry.MessageRegistry;
import dev.triumphteam.cmd.core.extension.sender.SenderExtension;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.context.InvalidCommandContext;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InternalParentCommand<D, S, ST>
implements InternalCommand<D, S, ST> {
    private final Map<String, InternalCommand<D, S, ST>> commands = new HashMap<String, InternalCommand<D, S, ST>>();
    private final Map<String, InternalCommand<D, S, ST>> commandAliases = new HashMap<String, InternalCommand<D, S, ST>>();
    private final CommandMeta meta;
    private final Settings<D, S> settings;
    private final MessageRegistry<S> messageRegistry;
    private final SenderExtension<D, S> senderExtension;
    private final SuggestionMapper<ST> suggestionMapper;

    public InternalParentCommand(@NotNull CommandProcessor<D, S, ST> processor) {
        Settings.Builder settingsBuilder = new Settings.Builder();
        processor.captureRequirements(settingsBuilder);
        this.meta = processor.createMeta(settingsBuilder);
        this.messageRegistry = processor.getRegistryContainer().getMessageRegistry();
        this.senderExtension = processor.getCommandOptions().getCommandExtensions().getSenderExtension();
        this.suggestionMapper = processor.getCommandOptions().getCommandExtensions().getSuggestionMapper();
        this.settings = settingsBuilder.build();
    }

    public void addCommands(@NotNull Object instance, @NotNull List<InternalCommand<D, S, ST>> commands) {
        for (InternalCommand<D, S, ST> command : commands) {
            if (command instanceof InternalBranchCommand && command.hasArguments() && this.commands.containsKey("th-args-cmd")) {
                throw new CommandRegistrationException("Only one inner command with argument is allowed per command", instance.getClass());
            }
            this.commands.put(command.getName(), command);
            for (String alias : command.getAliases()) {
                this.commandAliases.put(alias, command);
            }
        }
    }

    protected void findAndExecute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> arguments) throws Throwable {
        InternalCommand<D, S, ST> command = this.findCommand(sender, arguments, true);
        if (command == null) {
            return;
        }
        if (command instanceof InternalBranchCommand) {
            ((InternalBranchCommand)command).execute(sender, instanceSupplier, arguments);
            return;
        }
        InternalLeafCommand leafCommand = (InternalLeafCommand)command;
        leafCommand.execute(sender, instanceSupplier, leafCommand.mapArguments(arguments));
    }

    @NotNull
    public List<ST> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String argument = arguments.peek();
        if (argument == null) {
            return Collections.emptyList();
        }
        InternalCommand<D, S, ST> command = this.findCommand(sender, arguments, false);
        if (command == null) {
            return this.suggestionMapper.map(this.commands.entrySet().stream().filter(it -> !((InternalCommand)it.getValue()).isDefault()).filter(it -> ((InternalCommand)it.getValue()).getCommandSettings().testRequirements(sender, this.meta, this.senderExtension)).filter(it -> ((String)it.getKey()).startsWith(argument)).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        if (command instanceof InternalBranchCommand) {
            return ((InternalBranchCommand)command).suggestions(sender, arguments);
        }
        if (!(command instanceof InternalLeafCommand)) {
            return Collections.emptyList();
        }
        return ((InternalLeafCommand)command).suggestions(sender, new ArrayList<String>(arguments));
    }

    @Nullable
    public InternalCommand<D, S, ST> findCommand(@NotNull S sender, @NotNull Deque<String> arguments, boolean sendMessage) {
        String name = arguments.peek();
        InternalCommand<D, S, ST> defaultCommand = this.getCommandByName("th-default");
        if (name == null) {
            if (defaultCommand == null && sendMessage) {
                this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, sender, new InvalidCommandContext(this.meta, this.getSyntax(), ""));
            }
            return defaultCommand;
        }
        InternalCommand<D, S, ST> command = this.safelyGetCommandByName(name);
        if (command != null) {
            arguments.pop();
            return command;
        }
        if (defaultCommand == null || !defaultCommand.hasArguments()) {
            InternalCommand<D, S, ST> parentCommandWithArgument = this.getCommandByName("th-args-cmd");
            if (parentCommandWithArgument == null && sendMessage) {
                this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, sender, new InvalidCommandContext(this.meta, this.getSyntax(), name));
            }
            return parentCommandWithArgument;
        }
        return defaultCommand;
    }

    @Nullable
    public InternalCommand<D, S, ST> getCommand(@NotNull String name) {
        return this.commands.get(name);
    }

    @Override
    @NotNull
    public Settings<D, S> getCommandSettings() {
        return this.settings;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @NotNull
    public Map<String, InternalCommand<D, S, ST>> getCommands() {
        return this.commands;
    }

    @Nullable
    protected InternalCommand<D, S, ST> safelyGetCommandByName(@NotNull String key) {
        if (key.equals("th-default")) {
            return null;
        }
        if (key.equals("th-args-cmd")) {
            return null;
        }
        return this.getCommandByName(key);
    }

    @Nullable
    protected InternalCommand<D, S, ST> getCommandByName(@NotNull String key) {
        return this.commands.getOrDefault(key, this.commandAliases.get(key));
    }

    @Override
    @NotNull
    public CommandMeta getMeta() {
        return this.meta;
    }

    @NotNull
    protected MessageRegistry<S> getMessageRegistry() {
        return this.messageRegistry;
    }

    @NotNull
    protected Settings<D, S> getSettings() {
        return this.settings;
    }

    @NotNull
    protected SenderExtension<D, S> getSenderExtension() {
        return this.senderExtension;
    }
}

