/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.keyed.ListArgument;
import dev.triumphteam.cmd.core.argument.keyed.SimpleArgument;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Argument {
    @Contract(value=" -> new")
    @NotNull
    public static Builder forString() {
        return new Builder(String.class);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder forInt() {
        return new Builder(Integer.TYPE);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder forFloat() {
        return new Builder(Float.TYPE);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder forDouble() {
        return new Builder(Double.TYPE);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder forBoolean() {
        return new Builder(Boolean.TYPE);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder forType(@NotNull Class<?> type) {
        return new Builder(type);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CollectionBuilder listOf(@NotNull Class<?> type) {
        return new CollectionBuilder(List.class, type);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CollectionBuilder setOf(@NotNull Class<?> type) {
        return new CollectionBuilder(Set.class, type);
    }

    @NotNull
    public Class<?> getType();

    @NotNull
    public String getName();

    @Nullable
    public String getLongName();

    @NotNull
    public String getDescription();

    @Nullable
    public SuggestionKey getSuggestion();

    @NotNull
    public Argument asLongNameArgument();

    public boolean isLongNameArgument();

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder(@NotNull Class<?> type) {
            super(type);
        }

        @Override
        @NotNull
        protected Builder getThis() {
            return this;
        }
    }

    public static final class CollectionBuilder
    extends AbstractBuilder<CollectionBuilder> {
        private final Class<?> collectionType;
        private String separator = ",";

        public CollectionBuilder(@NotNull Class<?> collectionType, @NotNull Class<?> type) {
            super(type);
            this.collectionType = collectionType;
        }

        @Override
        @NotNull
        protected CollectionBuilder getThis() {
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public CollectionBuilder separator(@NotNull String separator) {
            this.separator = separator;
            return this;
        }

        @Override
        @Contract(value=" -> new")
        @NotNull
        public Argument build() {
            return new ListArgument(this);
        }

        @NotNull
        Class<?> getCollectionType() {
            return this.collectionType;
        }

        @NotNull
        String getSeparator() {
            return this.separator;
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private final Class<?> type;
        private String name;
        private String longName = null;
        private String description;
        private SuggestionKey suggestionKey;

        private AbstractBuilder(@NotNull Class<?> type) {
            this.type = type;
        }

        @NotNull
        protected abstract T getThis();

        @Contract(value="_ -> this")
        @NotNull
        public T name(@NotNull String name) {
            this.name = name;
            return this.getThis();
        }

        @Contract(value="_ -> this")
        @NotNull
        public T longName(@NotNull String longName) {
            this.longName = longName;
            return this.getThis();
        }

        @Contract(value="_ -> this")
        @NotNull
        public T description(@NotNull String description) {
            this.description = description;
            return this.getThis();
        }

        @Contract(value="_ -> this")
        @NotNull
        public T suggestion(@NotNull SuggestionKey suggestionKey) {
            this.suggestionKey = suggestionKey;
            return this.getThis();
        }

        @Contract(value=" -> new")
        @NotNull
        public Argument build() {
            return new SimpleArgument(this);
        }

        @NotNull
        Class<?> getType() {
            return this.type;
        }

        @NotNull
        String getName() {
            if (this.name == null || this.name.isEmpty()) {
                throw new CommandRegistrationException("Argument is missing a name!");
            }
            return this.name;
        }

        @Nullable
        String getLongName() {
            return this.longName;
        }

        @NotNull
        String getDescription() {
            return this.description;
        }

        @Nullable
        SuggestionKey getSuggestionKey() {
            return this.suggestionKey;
        }
    }
}

