/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.structure;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.files.FileManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureBuilder {
    private final FusionPaper fusion = (FusionPaper)FusionProvider.get();
    private final FileManager fileManager = this.fusion.getFileManager();
    private final StructureManager manager;
    private final JavaPlugin plugin;
    private final Server server;
    private final Set<BlockState> structureBlocks = new HashSet<BlockState>();
    private final Set<BlockState> initialBlocks = new HashSet<BlockState>();
    @Nullable
    private final BlockVector vector;
    private final Structure structure;
    private final NamespacedKey key;
    private final boolean isReady;

    public StructureBuilder(@NotNull JavaPlugin plugin, @NotNull NamespacedKey key) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.manager = this.server.getStructureManager();
        this.key = key;
        this.structure = this.manager.loadStructure(this.key);
        this.isReady = this.structure != null;
        this.vector = this.structure != null ? this.structure.getSize() : null;
    }

    public StructureBuilder(@NotNull JavaPlugin plugin, @NotNull String keyName) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.manager = this.server.getStructureManager();
        this.structure = this.manager.createStructure();
        this.vector = null;
        this.key = new NamespacedKey((Plugin)this.plugin, keyName);
        this.isReady = false;
    }

    public void saveStructure(@NotNull Path path, @Nullable Location uno, @Nullable Location dos, boolean includeEntities, boolean registerStructure) {
        if (uno == null || dos == null) {
            throw new FusionException("Cannot save structure as the file or one of the corners is null!");
        }
        this.structure.fill(uno, dos, includeEntities);
        try {
            this.manager.saveStructure(path.toFile(), this.structure);
            this.fileManager.addFile(path, FileType.NBT, (List)new ArrayList<FileAction>(){
                {
                    this.add(FileAction.MANUALLY_SAVED);
                }
            }, (UnaryOperator)null);
        }
        catch (IOException exception) {
            throw new FusionException("Failed to save structure!", exception);
        }
        if (registerStructure) {
            this.manager.registerStructure(this.key, this.structure);
        }
    }

    public void removeStructure(boolean restoreInitialBlocks) {
        if (!this.isReady) {
            return;
        }
        this.structureBlocks.forEach(state -> state.setType(Material.AIR));
        this.structureBlocks.clear();
        if (restoreInitialBlocks) {
            this.initialBlocks.forEach(state -> state.update(true));
            this.initialBlocks.clear();
        }
    }

    public void pasteStructure(@NotNull Location location) {
        if (!this.isReady) {
            return;
        }
        try {
            this.populate(true, location);
            this.structure.place(location, false, StructureRotation.NONE, Mirror.NONE, 0, 1.0f, (Random)ThreadLocalRandom.current());
            this.populate(false, location);
        }
        catch (Exception exception) {
            throw new FusionException("Failed to paste structure!", exception);
        }
    }

    @NotNull
    public Set<BlockState> getInitialBlocks() {
        return this.initialBlocks;
    }

    @NotNull
    public Set<BlockState> getStructureBlocks() {
        return this.structureBlocks;
    }

    @NotNull
    public NamespacedKey getNamespacedKey() {
        return this.key;
    }

    @NotNull
    public List<String> getBlacklist() {
        return new ArrayList<String>();
    }

    public double getX() {
        return this.isReady && this.vector != null ? this.vector.getX() : 0.0;
    }

    public double getY() {
        return this.isReady && this.vector != null ? this.vector.getY() : 0.0;
    }

    public double getZ() {
        return this.isReady && this.vector != null ? this.vector.getZ() : 0.0;
    }

    private void populate(boolean isInitial, @NotNull Location location) {
        int x = 0;
        while ((double)x < this.getX()) {
            int y = 0;
            while ((double)y < this.getY()) {
                int z = 0;
                while ((double)z < this.getZ()) {
                    Block relativeLocation = location.getBlock().getRelative(x, y, z);
                    if (isInitial) {
                        this.initialBlocks.add(relativeLocation.getState(false));
                    } else {
                        this.structureBlocks.add(relativeLocation.getState(false));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }
}

