/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.utils;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.api.builders.items.ItemBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.PatternBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.PotionBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.SkullBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.SpawnerBuilder;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final FusionPaper fusion = plugin.getFusion();
    private static final CrateManager crateManager = plugin.getCrateManager();

    public static void removeItem(@NotNull ItemStack item, @NotNull Player player) {
        int amount = item.getAmount();
        PlayerInventory inventory = player.getInventory();
        if (amount <= 1 && !inventory.isEmpty()) {
            inventory.removeItem(new ItemStack[]{item});
            return;
        }
        item.setAmount(amount - 1);
    }

    public static String getEnchant(@NotNull String enchant) {
        if (enchant.isEmpty()) {
            return "";
        }
        switch (enchant) {
            case "PROTECTION_ENVIRONMENTAL": {
                return "protection";
            }
            case "PROTECTION_FIRE": {
                return "fire_protection";
            }
            case "PROTECTION_FALL": {
                return "feather_falling";
            }
            case "PROTECTION_EXPLOSIONS": {
                return "blast_protection";
            }
            case "PROTECTION_PROJECTILE": {
                return "projectile_protection";
            }
            case "OXYGEN": {
                return "respiration";
            }
            case "WATER_WORKER": {
                return "aqua_affinity";
            }
            case "DAMAGE_ALL": {
                return "sharpness";
            }
            case "DAMAGE_UNDEAD": {
                return "smite";
            }
            case "DAMAGE_ARTHROPODS": {
                return "bane_of_arthropods";
            }
            case "LOOT_BONUS_MOBS": {
                return "looting";
            }
            case "SWEEPING_EDGE": {
                return "sweeping";
            }
            case "DIG_SPEED": {
                return "efficiency";
            }
            case "DURABILITY": {
                return "unbreaking";
            }
            case "LOOT_BONUS_BLOCKS": {
                return "fortune";
            }
            case "ARROW_DAMAGE": {
                return "power";
            }
            case "ARROW_KNOCKBACK": {
                return "punch";
            }
            case "ARROW_FIRE": {
                return "flame";
            }
            case "ARROW_INFINITE": {
                return "infinity";
            }
            case "LUCK": {
                return "luck_of_the_sea";
            }
        }
        return enchant.toLowerCase();
    }

    public static String getPotion(@NotNull String potion) {
        return potion.isEmpty() ? "" : potion.toLowerCase();
    }

    public static boolean isSimilar(@NotNull ItemStack itemStack, @NotNull Crate crate) {
        return crateManager.isKeyFromCrate(itemStack, crate);
    }

    public static String getKey(@NotNull PersistentDataContainerView container) {
        return (String)container.get(ItemKeys.crate_key.getNamespacedKey(), PersistentDataType.STRING);
    }

    @NotNull
    public static LegacyItemBuilder getItem(@NotNull ConfigurationSection section, @NotNull LegacyItemBuilder builder, @NotNull Player player) {
        return ItemUtils.getItem(section, (LegacyItemBuilder)builder.setPlayer(player));
    }

    @NotNull
    public static LegacyItemBuilder getItem(@NotNull ConfigurationSection section, @NotNull LegacyItemBuilder builder) {
        if (section.contains("Glowing")) {
            builder.setGlowing(section.getBoolean("Glowing", false));
        }
        builder.setDamage(section.getInt("DisplayDamage", 0));
        builder.setDisplayLore(section.getStringList("Lore"));
        builder.addPatterns(section.getStringList("Patterns"));
        builder.setHidingItemFlags(section.getBoolean("HideItemFlags", false) || !section.getStringList("Flags").isEmpty());
        builder.setUnbreakable(section.getBoolean("Unbreakable", false));
        if (section.contains("Skull")) {
            builder.setSkull(section.getString("Skull", ""));
        }
        if (section.contains("Player") && builder.isPlayerHead()) {
            builder.setPlayer(section.getString("Player", ""));
        }
        builder.setCustomModelData(section.getString("Custom-Model-Data", ""));
        builder.setItemModel(section.getString("Model.Namespace", ""), section.getString("Model.Id", ""));
        if (section.contains("DisplayTrim.Pattern") && builder.isArmor()) {
            builder.applyTrimPattern(section.getString("DisplayTrim.Pattern", "sentry"));
        }
        if (section.contains("DisplayTrim.Material") && builder.isArmor()) {
            builder.applyTrimMaterial(section.getString("DisplayTrim.Material", "quartz"));
        }
        if (section.contains("DisplayEnchantments")) {
            for (String ench : section.getStringList("DisplayEnchantments")) {
                String[] value = ench.split(":");
                builder.addEnchantment(value[0], Integer.parseInt(value[1]), true);
            }
        }
        return builder;
    }

    public static LegacyItemBuilder convertItemStack(@Nullable Player player, @NotNull ItemStack itemStack) {
        LegacyItemBuilder itemBuilder = new LegacyItemBuilder(plugin, itemStack);
        if (player != null) {
            itemBuilder.setPlayer(player);
        }
        return itemBuilder;
    }

    public static LegacyItemBuilder convertItemStack(@NotNull ItemStack itemStack) {
        return ItemUtils.convertItemStack(null, itemStack);
    }

    public static List<ItemBuilder> convertConfigurationSection(ConfigurationSection section) {
        ArrayList<ItemBuilder> cache = new ArrayList<ItemBuilder>();
        if (section == null) {
            return cache;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection patterns;
            String base64;
            ConfigurationSection item = section.getConfigurationSection(key);
            if (item == null) continue;
            ItemBuilder itemBuilder = ItemBuilder.from(item.getString("material", "stone"));
            if (item.contains("data") && (base64 = item.getString("data", null)) != null && !base64.isEmpty()) {
                itemBuilder.withBase64(base64);
            }
            if (item.contains("name")) {
                itemBuilder.setDisplayName(item.getString("name", ""));
            }
            if (item.contains("lore")) {
                itemBuilder.withDisplayLore(item.getStringList("lore"));
            }
            if (item.isString("amount")) {
                Optional<Number> integer = StringUtils.tryParseInt(item.getString("amount", "1"));
                integer.ifPresent(number -> itemBuilder.setAmount(number.intValue()));
            } else {
                itemBuilder.setAmount(item.getInt("amount", 1));
            }
            ConfigurationSection enchantments = item.getConfigurationSection("enchantments");
            if (enchantments != null) {
                for (String enchantment : enchantments.getKeys(false)) {
                    int level = enchantments.getInt(enchantment);
                    itemBuilder.addEnchantment(enchantment, level);
                }
            }
            itemBuilder.setCustomModelData(item.getString("custom-model-data", ""));
            if (item.getBoolean("hide-tool-tip", false)) {
                itemBuilder.hideToolTip();
            }
            itemBuilder.hideComponents(item.getStringList("hidden-components"));
            itemBuilder.setUnbreakable(item.getBoolean("unbreakable-item", false));
            itemBuilder.setEnchantGlint(item.getBoolean("settings.glowing", false));
            String player = item.getString("settings.player", null);
            if (player != null && !player.isEmpty() && itemBuilder.isPlayerHead()) {
                SkullBuilder skullBuilder = itemBuilder.asSkullBuilder();
                skullBuilder.withName(player).build();
            }
            itemBuilder.setItemDamage(item.getInt("settings.damage", 0));
            itemBuilder.withSkull(item.getString("settings.skull", ""));
            String rgb = item.getString("settings.rgb", "");
            String color = item.getString("settings.color", "");
            String value = !color.isEmpty() ? color : (!rgb.isEmpty() ? rgb : "");
            itemBuilder.setColor(value);
            String mobType = item.getString("settings.mob.type", null);
            if (mobType != null && !mobType.isEmpty()) {
                SpawnerBuilder spawnerBuilder = itemBuilder.asSpawnerBuilder();
                spawnerBuilder.withEntityType(com.ryderbelserion.fusion.paper.utils.ItemUtils.getEntity(mobType)).build();
            }
            itemBuilder.setTrim(item.getString("settings.trim.pattern", ""), item.getString("settings.trim.material", ""));
            if (itemBuilder.isPotion()) {
                ConfigurationSection potions = item.getConfigurationSection("settings.potions");
                PotionBuilder potionBuilder = itemBuilder.asPotionBuilder();
                if (potions != null) {
                    for (String potion : potions.getKeys(false)) {
                        ConfigurationSection data;
                        PotionEffectType type = com.ryderbelserion.fusion.paper.utils.ItemUtils.getPotionEffect(potion);
                        if (type == null || (data = potions.getConfigurationSection(potion)) == null) continue;
                        int duration = data.getInt("duration", 10) * 20;
                        int level = data.getInt("level", 1);
                        boolean icon = data.getBoolean("style.icon", false);
                        boolean ambient = data.getBoolean("style.ambient", false);
                        boolean particles = data.getBoolean("style.particles", false);
                        potionBuilder.withPotionEffect(type, duration, level, ambient, particles, icon);
                    }
                }
                potionBuilder.setColor(value).build();
            }
            if ((patterns = item.getConfigurationSection("settings.patterns")) != null) {
                PatternBuilder patternBuilder = itemBuilder.asPatternBuilder();
                for (String pattern : patterns.getKeys(false)) {
                    String patternColor = patterns.getString(pattern, "white");
                    patternBuilder.addPattern(pattern, patternColor);
                }
                patternBuilder.build();
            }
            cache.add(itemBuilder);
        }
        return cache;
    }

    public static List<LegacyItemBuilder> convertStringList(@NotNull List<String> itemStrings, @NotNull String section) {
        return itemStrings.stream().map(itemString -> ItemUtils.convertString(itemString, section)).collect(Collectors.toList());
    }

    public static LegacyItemBuilder convertString(@NotNull String itemString, @NotNull String section) {
        LegacyItemBuilder itemBuilder = new LegacyItemBuilder(plugin);
        try {
            block42: for (String optionString : itemString.split(", ")) {
                String option = optionString.split(":")[0];
                String value = optionString.replace(option + ":", "").replace(option, "");
                switch (option.toLowerCase()) {
                    case "item": {
                        itemBuilder.withType(value.toLowerCase());
                        continue block42;
                    }
                    case "data": {
                        itemBuilder = itemBuilder.fromBase64(value);
                        continue block42;
                    }
                    case "name": {
                        itemBuilder.setDisplayName(value);
                        continue block42;
                    }
                    case "mob": {
                        EntityType type = com.ryderbelserion.fusion.paper.utils.ItemUtils.getEntity(value);
                        if (type == null) continue block42;
                        itemBuilder.setEntityType(type);
                        continue block42;
                    }
                    case "glowing": {
                        itemBuilder.setGlowing(StringUtils.tryParseBoolean(value).orElse(false));
                        continue block42;
                    }
                    case "amount": {
                        Object amount = StringUtils.tryParseInt(value);
                        itemBuilder.setAmount(((Optional)amount).map(Number::intValue).orElse(1));
                        continue block42;
                    }
                    case "damage": {
                        Object amount = StringUtils.tryParseInt(value);
                        itemBuilder.setDamage(((Optional)amount).map(Number::intValue).orElse(0));
                        continue block42;
                    }
                    case "lore": {
                        itemBuilder.setDisplayLore(List.of(value.split(",")));
                        continue block42;
                    }
                    case "player": {
                        itemBuilder.setPlayer(value);
                        continue block42;
                    }
                    case "skull": {
                        itemBuilder.setSkull(value);
                        continue block42;
                    }
                    case "custom-model-data": {
                        itemBuilder.setCustomModelData(value);
                        continue block42;
                    }
                    case "unbreakable-item": {
                        itemBuilder.setUnbreakable(value.isEmpty() || value.equalsIgnoreCase("true"));
                        continue block42;
                    }
                    case "hide-tool-tip": {
                        itemBuilder.setHidingItemFlags(value.equalsIgnoreCase("true"));
                        continue block42;
                    }
                    case "trim-pattern": {
                        itemBuilder.applyTrimPattern(value);
                        continue block42;
                    }
                    case "trim-material": {
                        itemBuilder.applyTrimMaterial(value);
                        continue block42;
                    }
                    case "rgb": {
                        @Nullable @Nullable Color color = ColorUtils.getRGB(value);
                        if (color == null) continue block42;
                        itemBuilder.setColor(color);
                        continue block42;
                    }
                    case "color": {
                        @Nullable @Nullable Color color = ColorUtils.getColor(value);
                        itemBuilder.setColor(color);
                        continue block42;
                    }
                    default: {
                        @Nullable @Nullable Color color;
                        Object amount;
                        if (com.ryderbelserion.fusion.paper.utils.ItemUtils.getEnchantment(option.toLowerCase()) != null) {
                            amount = StringUtils.tryParseInt(value);
                            itemBuilder.addEnchantment(option.toLowerCase(), ((Optional)amount).map(Number::intValue).orElse(1), true);
                            continue block42;
                        }
                        for (ItemFlag itemFlag : ItemFlag.values()) {
                            if (!itemFlag.name().equalsIgnoreCase(option)) continue;
                            itemBuilder.setHidingItemFlags(true);
                            break;
                        }
                        try {
                            color = ColorUtils.getDyeColor(value);
                            PatternType patternType = com.ryderbelserion.fusion.paper.utils.ItemUtils.getPatternType(option.toLowerCase());
                            if (patternType == null) continue block42;
                            itemBuilder.addPattern(patternType, (DyeColor)color);
                            continue block42;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ((LegacyItemBuilder)itemBuilder.withType((ItemType)ItemType.RED_TERRACOTTA)).setDisplayName("<red>Error found!, Prize Name: " + section);
            fusion.log("error", "An error has occurred with the prize {}, {}", section, exception.getMessage());
        }
        return itemBuilder;
    }
}

