/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.managers.events;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.core.files.types.LogCustomFile;
import com.ryderbelserion.fusion.paper.files.FileManager;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class EventManager {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final ComponentLogger logger = plugin.getComponentLogger();
    private static final SettingsManager config = ConfigManager.getConfig();
    private static final FileManager fileManager = plugin.getFileManager();

    public static void logEvent(@NotNull EventType type, @NotNull String name, @NotNull CommandSender sender, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        EventManager.handle(type, name, sender, crate, keyType, amount);
    }

    private static void handle(@NotNull EventType type, @NotNull String name, @NotNull CommandSender sender, @NotNull Crate crate, @NotNull KeyType keyType, int amount) {
        Object message = "";
        Path path = null;
        switch (type) {
            case event_key_given: 
            case event_key_removed: 
            case event_key_received: 
            case event_key_sent: 
            case event_key_taken: 
            case event_key_taken_multiple: {
                message = "Player: %player% | Sender: %sender% | Key Name: %key_name%<reset> | Key Type: %key_type%".replace("%key_type%", keyType.getFriendlyName()).replace("%player%", name).replace("%sender%", sender.getName()).replace("%key_name%", crate.getKeyName());
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                path = FileKeys.key_log.getPath();
                break;
            }
            case event_crate_opened: {
                message = "Player: %player% | Crate Name: %crate_name%<reset> | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name%<reset> | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", name).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "no");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                path = FileKeys.crate_log.getPath();
                break;
            }
            case event_crate_force_opened: {
                message = "Player: %player% | Crate Name: %crate_name%<reset> | Force Opened: %force_opened% | Crate Type: %crate_type% | Key Name: %key_name%<reset> | Key Type: %key_type% | Key Item: %key_item%".replace("%player%", name).replace("%crate_name%", crate.getCrateName()).replace("%crate_type%", crate.getCrateType().getName()).replace("%key_name%", crate.getKeyName()).replace("%key_type%", keyType.getFriendlyName()).replace("%key_item%", crate.getKey().getType().getKey().getKey()).replace("%force_opened%", "yes");
                if (amount >= 1) {
                    message = (String)message + " | Amount: %amount%".replace("%amount%", String.valueOf(amount));
                }
                path = FileKeys.crate_log.getPath();
            }
        }
        EventManager.log((String)message, path, type);
    }

    private static void log(@NotNull String message, @Nullable Path path, @NotNull EventType type) {
        boolean log_to_console;
        LogCustomFile customFile;
        String time = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(System.currentTimeMillis()));
        if (path != null && config.getProperty(ConfigKeys.log_to_file).booleanValue() && (customFile = (LogCustomFile)fileManager.getCustomFile(path)) != null) {
            customFile.save("[" + time + " " + type.getEvent() + "]: " + PlainTextComponentSerializer.plainText().serialize(AdvUtils.parse(message)), (List)new ArrayList());
        }
        if (log_to_console = config.getProperty(ConfigKeys.log_to_console).booleanValue()) {
            logger.info("[{} {}]: {}", new Object[]{time, type.getEvent(), AdvUtils.parse(message)});
        }
    }
}

