/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.builders;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.InventoryBuilder;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.events.CrateOpenEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.crates.effects.SoundEffect;
import com.badbones69.crazycrates.paper.tasks.crates.other.CosmicCrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CratePrizeMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.google.common.base.Preconditions;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public abstract class CrateBuilder
extends FoliaScheduler {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final ComponentLogger logger = this.plugin.getComponentLogger();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    private final InventoryBuilder builder;
    private final Inventory inventory;
    private final Location location;
    private final Player player;
    private final Crate crate;
    private final int size;
    protected final SettingsManager config = ConfigManager.getConfig();
    protected boolean isCancelled = false;

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size, @NotNull String title) {
        super((JavaPlugin)CrazyCrates.getPlugin(), null, (Entity)player);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        this.location = player.getLocation();
        this.player = player;
        this.crate = crate;
        this.size = size;
        this.builder = new CratePrizeMenu(player, title.isEmpty() ? this.getTitle() : title, size, crate);
        this.inventory = this.builder.build().getInventory();
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size) {
        this(crate, player, size, "");
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, int size, @NotNull Location location) {
        super((JavaPlugin)CrazyCrates.getPlugin(), null, (Entity)player);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        Preconditions.checkNotNull((Object)location, (Object)"Location can't be null.");
        this.location = location;
        this.player = player;
        this.crate = crate;
        this.size = size;
        this.builder = new CratePrizeMenu(player, this.getTitle(), size, crate);
        this.inventory = this.builder.build().getInventory();
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player, @NotNull Location location) {
        super((JavaPlugin)CrazyCrates.getPlugin(), null, (Entity)player);
        Preconditions.checkNotNull((Object)crate, (Object)"Crate can't be null.");
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null.");
        Preconditions.checkNotNull((Object)location, (Object)"Location can't be null.");
        this.location = location;
        this.player = player;
        this.crate = crate;
        this.size = 0;
        this.builder = null;
        this.inventory = null;
    }

    public CrateBuilder(@NotNull Crate crate, @NotNull Player player) {
        this(crate, player, player.getLocation());
    }

    public abstract void open(@NotNull KeyType var1, boolean var2, boolean var3, EventType var4);

    public void displayItem(final Prize prize) {
        boolean showQuickCrateItem = ConfigManager.getConfig().getProperty(ConfigKeys.show_quickcrate_item);
        if (showQuickCrateItem) {
            CrateLocation crateLocation;
            HologramManager manager = this.crateManager.getHolograms();
            if (manager != null && this.crate.getHologram().isEnabled() && (crateLocation = this.crateManager.getCrateLocation(this.location)) != null) {
                manager.removeHologram(crateLocation.getID());
            }
            final ItemStack display = prize.getDisplayItem(this.player, this.crate);
            display.editPersistentDataContainer(container -> container.set(ItemKeys.crate_prize.getNamespacedKey(), PersistentDataType.STRING, (Object)"1"));
            new FoliaScheduler(this.plugin, this.location){

                @Override
                public void run() {
                    Item reward;
                    try {
                        reward = CrateBuilder.this.player.getWorld().dropItem(CrateBuilder.this.location.clone().add(0.5, 1.0, 0.5), display);
                    }
                    catch (IllegalArgumentException exception) {
                        String crateName = prize.getCrateName();
                        String prizeName = prize.getPrizeName();
                        List.of("A prize could not be given due to an invalid display item for this prize.", "Crate: %s Prize: %s").forEach(line -> CrateBuilder.this.logger.warn(String.format(line, crateName, prizeName), (Throwable)exception));
                        this.cancel();
                        return;
                    }
                    reward.setVelocity(new Vector(0.0, 0.2, 0.0));
                    reward.customName(AdvUtils.parse(prize.getPrizeName()));
                    reward.setCustomNameVisible(true);
                    reward.setCanMobPickup(false);
                    reward.setCanPlayerPickup(false);
                    CrateBuilder.this.crateManager.addReward(CrateBuilder.this.player, (Entity)reward);
                }
            }.runNow();
        }
    }

    public void addCrateTask(@NotNull ScheduledTask task) {
        this.crateManager.addCrateTask(this.player, task);
    }

    public void removeTask() {
        this.crateManager.removeCrateTask(this.player);
    }

    public void cancelCrateTask() {
        this.crateManager.getCrateTask(this.player).cancel();
        this.removeTask();
    }

    public final boolean hasCrateTask() {
        return this.crateManager.hasCrateTask(this.player);
    }

    @NotNull
    public final Crate getCrate() {
        return this.crate;
    }

    @NotNull
    public final String getTitle() {
        return this.crate.getAnimationName();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isFireCracker() {
        return this.crate.getCrateType() == CrateType.fire_cracker;
    }

    public final boolean isCosmicCrate() {
        return this.crate.getCrateType() == CrateType.cosmic;
    }

    public final YamlConfiguration getFile() {
        return this.crate.getFile();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Location getLocation() {
        return this.location;
    }

    public InventoryBuilder getMenu() {
        return this.builder.build();
    }

    public void setItem(int slot, @NotNull ItemStack item) {
        this.inventory.setItem(slot, item);
    }

    public void setItem(int slot, @NotNull ItemType itemType, @NotNull String name, @NotNull List<String> lore) {
        this.inventory.setItem(slot, ((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin, itemType).setPlayer(this.player)).setDisplayName(name)).setDisplayLore(lore)).asItemStack());
    }

    public void setItem(int slot, @NotNull ItemType itemType, @NotNull String name) {
        this.inventory.setItem(slot, ((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin, itemType).setPlayer(this.player)).setDisplayName(name)).asItemStack());
    }

    public void setCustomGlassPane(int slot) {
        this.inventory.setItem(slot, this.getRandomGlassPane());
    }

    @NotNull
    public final ItemStack getRandomGlassPane() {
        return ((LegacyItemBuilder)MiscUtils.getRandomPaneColor().setDisplayName(" ")).asItemStack();
    }

    public final boolean isCrateEventValid(@NotNull KeyType keyType, boolean checkHand, boolean isSilent, EventType eventType) {
        CrateOpenEvent event = new CrateOpenEvent(this.player, this.crate, keyType, checkHand, this.crate.getFile(), isSilent, eventType);
        event.callEvent();
        if (event.isCancelled() && MiscUtils.isLogging()) {
            String fileName = this.crate.getFileName();
            String playerName = this.player.getName();
            if (this.config.getProperty(ConfigKeys.use_new_permission_system).booleanValue() && this.player.hasPermission("crazycrates.deny.open." + fileName)) {
                this.logger.warn("{} could not open {} due to having the permission preventing them from opening the crate.", (Object)playerName, (Object)fileName);
            } else if (!this.player.hasPermission("crazycrates.open." + fileName)) {
                this.logger.warn("{} could not open {} due to not having the permission required to open the crate.", (Object)playerName, (Object)fileName);
            } else if (!this.crate.canWinPrizes(this.player)) {
                this.logger.warn("{} could not open {} due to no valid prizes being found which led to the event being cancelled.", (Object)playerName, (Object)fileName);
            }
        }
        return event.isCancelled();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.isCancelled = true;
    }

    public ItemStack getDisplayItem() {
        return this.crate.pickPrize(this.player).getDisplayItem(this.player, this.crate);
    }

    public ItemStack getDisplayItem(@NotNull Tier tier) {
        return this.crate.pickPrize(this.player, tier).getDisplayItem(this.player, this.crate);
    }

    public void playSound(@NotNull String type, @NotNull Sound.Source source, @NotNull String fallback) {
        if (type.isEmpty() && fallback.isEmpty()) {
            return;
        }
        ConfigurationSection section = this.getFile().getConfigurationSection("Crate.sound");
        if (section != null) {
            SoundEffect sound = new SoundEffect(section, type, fallback, source);
            sound.play(this.player, this.player.getLocation());
        }
    }

    public final void populateTiers() {
        CosmicCrateManager manager = (CosmicCrateManager)this.crate.getManager();
        LegacyItemBuilder itemBuilder = (LegacyItemBuilder)manager.getMysteryCrate().setPlayer(this.player);
        for (int slot = 0; slot <= this.size; ++slot) {
            ((LegacyItemBuilder)itemBuilder.addNamePlaceholder("%Slot%", String.valueOf(slot))).addLorePlaceholder("%Slot%", String.valueOf(slot));
            itemBuilder.setAmount(slot);
            Tier tier = PrizeManager.getTier(this.crate);
            if (tier == null) continue;
            this.crateManager.addTier(this.player, slot, tier);
            this.getInventory().setItem(this.getInventory().firstEmpty(), itemBuilder.asItemStack());
        }
    }
}

