/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.MoreNumberTypes;
import ch.jalu.typeresolver.numbers.NumberType;
import ch.jalu.typeresolver.numbers.StandardNumberType;
import ch.jalu.typeresolver.primitives.PrimitiveType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class NumberTypes {
    private static final Map<Class<?>, NumberType<?>> NUMBER_TYPES_BY_CLASS = NumberTypes.collectAllNumberTypesByClass();

    private NumberTypes() {
    }

    @Nullable
    public static <T> NumberType<T> from(@Nullable Class<T> clazz) {
        return NUMBER_TYPES_BY_CLASS.get(clazz);
    }

    public static Stream<NumberType<?>> streamThroughAll() {
        return Stream.concat(StandardNumberType.streamThroughAll(), Stream.of(MoreNumberTypes.CHARACTER, MoreNumberTypes.ATOMIC_INTEGER, MoreNumberTypes.ATOMIC_LONG));
    }

    @Nullable
    public static Number unwrapToStandardNumberType(@Nullable Object object) {
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        if (object instanceof Number) {
            return NumberTypes.unwrapToStandardNumberType((Number)object);
        }
        return null;
    }

    public static Number unwrapToStandardNumberType(Number number) {
        if (number instanceof AtomicInteger) {
            return number.intValue();
        }
        if (number instanceof AtomicLong || number instanceof LongAccumulator || number instanceof LongAdder) {
            return number.longValue();
        }
        if (number instanceof DoubleAccumulator || number instanceof DoubleAdder) {
            return number.doubleValue();
        }
        return number;
    }

    private static Map<Class<?>, NumberType<?>> collectAllNumberTypesByClass() {
        HashMap numberTypeByClass = new HashMap();
        NumberTypes.streamThroughAll().forEach(numberType -> {
            numberTypeByClass.put(numberType.getType(), numberType);
            Class<?> primitiveType = PrimitiveType.toPrimitiveType(numberType.getType());
            numberTypeByClass.put(primitiveType, numberType);
        });
        return Collections.unmodifiableMap(numberTypeByClass);
    }
}

