/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import ch.jalu.typeresolver.CommonTypeUtils;
import ch.jalu.typeresolver.array.ArrayTypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

final class TypeToClassUtils {
    private TypeToClassUtils() {
    }

    @Nullable
    public static Class<?> getSafeToWriteClass(@Nullable Type type) {
        GenericArrayType gat;
        Class<?> componentAsClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return CommonTypeUtils.getRawType(pt);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return TypeToClassUtils.getFirstNonNull(TypeToClassUtils::getSafeToWriteClass, wt.getLowerBounds());
        }
        if (type instanceof GenericArrayType && (componentAsClass = TypeToClassUtils.getSafeToWriteClass((gat = (GenericArrayType)type).getGenericComponentType())) != null) {
            return ArrayTypeUtils.createArrayClass(componentAsClass);
        }
        return null;
    }

    public static Class<?> getSafeToReadClass(@Nullable Type type) {
        Class<?> clazz = TypeToClassUtils.getSafeToReadClassOrNull(type);
        return clazz == null ? Object.class : clazz;
    }

    @Nullable
    private static Class<?> getSafeToReadClassOrNull(@Nullable Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return CommonTypeUtils.getRawType(pt);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            if (CommonTypeUtils.hasExplicitUpperBound(wt)) {
                return TypeToClassUtils.getFirstNonNull(TypeToClassUtils::getSafeToReadClassOrNull, wt.getUpperBounds());
            }
        } else {
            if (type instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)type;
                return TypeToClassUtils.getFirstNonNull(TypeToClassUtils::getSafeToReadClassOrNull, tv.getBounds());
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)type;
                Class<?> componentAsClass = TypeToClassUtils.getSafeToReadClassOrNull(gat.getGenericComponentType());
                if (componentAsClass != null) {
                    return ArrayTypeUtils.createArrayClass(componentAsClass);
                }
                return Object[].class;
            }
        }
        return null;
    }

    @Nullable
    private static Class<?> getFirstNonNull(Function<Type, Class<?>> converter, Type[] inputs) {
        return Arrays.stream(inputs).map(converter).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

