/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.utils;

import ch.jalu.configme.exception.ConfigMeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public final class FileUtils {
    private FileUtils() {
    }

    public static void createFileIfNotExists(@NotNull Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new ConfigMeException("Expected file but '" + String.valueOf(file) + "' is not a file");
            }
        } else {
            Path parent = file.getParent();
            if (!Files.exists(parent, new LinkOption[0]) || !Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ConfigMeException("Failed to create parent folders for '" + String.valueOf(file) + "'", e);
                }
            }
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ConfigMeException("Failed to create file '" + String.valueOf(file) + "'", e);
            }
        }
    }
}

