/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.internal.ConversionUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionPropertyType<E, C extends Collection<E>>
implements PropertyType<C> {
    private final PropertyType<E> entryType;

    public CollectionPropertyType(@NotNull PropertyType<E> entryType) {
        this.entryType = entryType;
    }

    @NotNull
    public static <E, C extends Collection<E>> CollectionPropertyType<E, C> of(@NotNull PropertyType<E> entryType, final @NotNull Collector<E, ?, C> collector) {
        return new CollectionPropertyType<E, C>(entryType){

            @Override
            @NotNull
            protected Collector<E, ?, C> resultCollector() {
                return collector;
            }
        };
    }

    @Override
    @Nullable
    public C convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            return (C)((Collection)coll.stream().map(elem -> ConversionUtils.convertOrLogError(elem, this.entryType, errorRecorder)).filter(Objects::nonNull).collect(this.resultCollector()));
        }
        return null;
    }

    @NotNull
    public List<?> toExportValue(@NotNull C value) {
        return value.stream().map(this.entryType::toExportValue).collect(Collectors.toList());
    }

    @NotNull
    public PropertyType<E> getEntryType() {
        return this.entryType;
    }

    @NotNull
    protected abstract Collector<E, ?, C> resultCollector();
}

